% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{admm_MADMMplasso_cpp}
\alias{admm_MADMMplasso_cpp}
\title{Fit the ADMM part of  model for a given lambda vale}
\usage{
admm_MADMMplasso_cpp(
  beta0,
  theta0,
  beta,
  beta_hat,
  theta,
  rho1,
  X,
  Z,
  max_it,
  W_hat,
  XtY,
  y,
  N,
  e_abs,
  e_rel,
  alpha,
  lambda,
  alph,
  svd_w_tu,
  svd_w_tv,
  svd_w_d,
  C,
  CW,
  gg,
  my_print = TRUE
)
}
\arguments{
\item{beta0}{a vector of length ncol(y) of estimated beta_0 coefficients}

\item{theta0}{matrix of the initial theta_0 coefficients  ncol(Z) by ncol(y)}

\item{beta}{a matrix of the initial beta coefficients    ncol(X) by ncol(y)}

\item{beta_hat}{a matrix of the initial beta and theta coefficients    (ncol(X)+ncol(X) by ncol(Z)) by ncol(y)}

\item{theta}{an array of initial theta coefficients    ncol(X) by ncol(Z) by ncol(y)}

\item{rho1}{the Lagrange variable for the ADMM which is usually included as rho in the MADMMplasso call.}

\item{X}{n by p matrix of predictors}

\item{Z}{n by nz matrix of modifying variables. The elements of z
may represent quantitative or categorical variables, or a mixture of the two.
Categorical variables should be coded by 0-1 dummy variables: for a k-level
variable, one can use either k or k-1  dummy variables.}

\item{max_it}{maximum number of iterations in loop for one lambda during the ADMM optimization. This is usually included  in the MADMMplasso call}

\item{W_hat}{N by (p+(p by nz)) of the main and interaction predictors. This generated internally  when MADMMplasso is called or by using the function generate_my_w.}

\item{XtY}{a matrix formed by multiplying the transpose of X by y.}

\item{y}{N by D matrix  of responses. The X and Z variables are centered in the function. We recommend that X and Z also be standardized before the call}

\item{N}{nrow(X)}

\item{e_abs}{absolute error for the ADMM. This is included int the call of MADMMplasso.}

\item{e_rel}{relative error for the ADMM. This is included int the call of MADMMplasso.}

\item{alpha}{mixing parameter, usually obtained from the MADMMplasso call. When the goal is to include more interactions, alpha should be very small and vice versa.}

\item{lambda}{a vector  lambda_3 values for the ADMM call with length ncol(y). This is usually calculated in the MADMMplasso call.   In our current setting, we use the same the lambda_3 value for all responses.}

\item{alph}{an overrelaxation parameter in [1, 1.8], usually obtained from the MADMMplasso call.}

\item{svd_w_tu}{the transpose of the U matrix from the SVD of W_hat}

\item{svd_w_tv}{the transpose of the V matrix from the SVD of W_hat}

\item{svd_w_d}{the D matrix from the SVD of W_hat}

\item{C}{the trained tree}

\item{CW}{weights for the trained tree
The easy way to obtain this is by using the function (tree_parms) which gives a default clustering.
However, user decide on a specific structure and then input a tree that follows such structure.}

\item{gg}{penalty terms for the tree structure for lambda_1 and  lambda_2 for the ADMM call.}

\item{my_print}{Should information form each ADMM iteration be printed along the way? Default TRUE. This prints  the dual and primal residuals}
}
\value{
predicted values for the ADMM part
}
\description{
This function fits a multi-response pliable lasso model over a path of regularization values.
}
