% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc_on_target}
\alias{qc_on_target}
\title{Check that QC measurement is at the required target
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
\usage{
qc_on_target(
  measurement,
  strain,
  ab,
  ignore_na = TRUE,
  guideline = "EUCAST",
  year = "2023"
)
}
\arguments{
\item{measurement}{measured QC MIC}

\item{strain}{control strain identifier (usually ATCC)}

\item{ab}{antibiotic name (will be coerced to AMR::as.ab)}

\item{ignore_na}{ignores NA (returns TRUE)}

\item{guideline}{Guideline to use (EUCAST or CLSI)}

\item{year}{Guideline year (version)}
}
\value{
logical vector
}
\description{
MIC experiments should include a control strain with a known MIC.
The MIC result for the control strain should be a particular target MIC. This
function checks whether the target MIC was achieved given: 1) a control
strain (usually identified as an ATCC or NCTC number), 2) an antibiotic name,
and 3) a guideline (EUCAST or CLSI).

Since QC target values are currently not publicly available in an easy to
use format, this function takes a pragmatic approach -- for most antibiotics
and QC strains, the target is assumed to be the midpoint of the acceptable
range. This approximation is not necessarily equal to the QC target reported
by guideline setting bodies such as EUCAST. Therefore, this function is
considered experimental and should be used with caution.

This function can be used alongnside qc_in_range(), which checks whether the
MIC is within the acceptable range.

The source of the QC values is the WHONET QC Ranges and Targets available from
the 'Antimicrobial Resistance Test Interpretation Engine' (AMRIE) repository:
https://github.com/AClark-WHONET/AMRIE
}
\examples{
qc_on_target(AMR::as.mic(0.5), 25922, "GEN") == TRUE
}
\references{
O’Brien TF, Stelling JM. WHONET: An Information System for Monitoring
Antimicrobial Resistance. Emerg Infect Dis. 1995 Jun;1(2):66–66.
}
