% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateInput.R
\name{GenerateReference}
\alias{GenerateReference}
\title{Generate reference pattern labels (no default writing)}
\usage{
GenerateReference(binary_file, min_CG = 50, output_path = NULL)
}
\arguments{
\item{binary_file}{Path to the pattern strings file (one string per line).}

\item{min_CG}{Minimum CpG count a pattern must have to keep its own ID (default: 50).
Patterns with frequency <= `min_CG` are grouped as "Pna".}

\item{output_path}{Optional file path to write the resulting labels. If `NULL` (default),
nothing is written and the labels are only returned.}
}
\value{
A character vector of pattern labels (same length/order as the input file).
}
\description{
Generate reference pattern labels (no default writing)
}
\examples{
\dontrun{
# DO write only to a temp location in examples/vignettes/tests:
tmp_out <- file.path(tempdir(), "patterns.txt")
labs <- GenerateReference("path/to/pattern_strings.txt", min_CG = 50, output_path = tmp_out)
# Or skip writing and just get the vector:
labs <- GenerateReference("path/to/pattern_strings.txt", min_CG = 50)
}
}
