% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmadt.hierarchical.MNAR.R
\name{nmadt.hierarchical.MNAR}
\alias{nmadt.hierarchical.MNAR}
\title{Hierarchical Model Network Meta-Analysis of Diagnostic Accuracy Studies Under MNAR Assumptions}
\usage{
nmadt.hierarchical.MNAR(
  nstu,
  K,
  data,
  testname,
  directory = NULL,
  diag = 5,
  off_diag = 0.05,
  digits = 4,
  mu_alpha = 0,
  mu_beta = 0,
  mu_eta = -0,
  preci_alpha = 0.1,
  preci_beta = 0.1,
  preci_eta = 0.1,
  gamma1,
  gamma0,
  mu_gamma = 0,
  preci_gamma = 1,
  n.burnin = floor(n.iter/2),
  n.thin = max(1, floor((n.iter - n.burnin)/1e+05)),
  n.adapt = 5000,
  n.iter = 50000,
  n.chains = 3,
  conv.diag = FALSE,
  trace = NULL,
  dic = FALSE,
  mcmc.samples = FALSE
)
}
\arguments{
\item{nstu}{an integer indicating the number of studies included in the dataset.}

\item{K}{an integer indicating the number of candidate test in the dataset.}

\item{data}{a list containing the input dataset to be used for meta-analysis.}

\item{testname}{a string vector of the names of the candidate tests in the dataset in the same order as presetned in the dataset.}

\item{directory}{a string specifying the designated directory to save trace plots or potential scale reduction factors calculated in the function. The default is NULL.}

\item{diag}{A number specifying the diagonal entries of the scale matrix $R$ in the
Wishart prior for the precision matrix \eqn{\Sigma^{-1}}. Larger values of \code{diag}
typically imply stronger prior shrinkage, favoring smaller between-study variability in
prevalence, sensitivity, and specificity. The default is \code{5}.}

\item{off_diag}{A number specifying the off-diagonal entries of the scale matrix $R$ in the
Wishart prior for \eqn{\Sigma^{-1}}, controlling the strength of prior dependence among
random effects (e.g., correlations between sensitivity and specificity and their association
with prevalence). The default is \code{0.05}. If strong correlations are expected, users may
increase \code{off_diag}; if substantially larger heterogeneity is anticipated, users may
decrease \code{diag}. We recommend sensitivity analyses alongside standard MCMC diagnostics.}

\item{digits}{A positive integer specifying the number of digits to the right of the decimal
point to keep in the printed results; the default is \code{digits = 4}.}

\item{mu_alpha}{a number indicating the mean of the normal distribution that the prior of the fixed effect for sensitivity follows. The default is 0.}

\item{mu_beta}{a number indicating the mean of the normal distribution that the prior of the fixed effect for specificity follows. The default is 0.}

\item{mu_eta}{a number indicating the mean of the normal distribution that the prior of the fixed effect for prevalence follows. The default is 0.}

\item{preci_alpha}{a number indicating the precision of the normal distribution that the prior of the fixed effect for sensitivity follows. The default is $0.1$.}

\item{preci_beta}{a number indicating the precision of the normal distribution that the prior of the fixed effect for specificity follows. The default is $0.1$.}

\item{preci_eta}{a number indicating the precision of the normal distribution that the prior of the fixed effect for prevalence follows. The default is $0.1$.}

\item{gamma1}{A numeric vector (length \code{K}) for coefficients on \eqn{\text{logit}(\text{Se}_{ik})}
in the MNAR missingness model. Recommended to treat as sensitivity-analysis parameters.
See \code{gamma0} for suggested grids and interpretation.}

\item{gamma0}{A numeric vector (length \code{K}) for coefficients on \eqn{\text{logit}(\text{Sp}_{ik})}
in the MNAR missingness model. Recommended to treat as sensitivity-analysis parameters.
\eqn{\gamma_{0k}=0} corresponds to MAR with respect to accuracy; negative values
(e.g., \code{c(0, -0.5, -1, -2)}) represent the common assumption that tests with poorer accuracy
are more likely to be missing.}

\item{mu_gamma}{a number specifying mean of intercept in the MNAR model. The default is 0.}

\item{preci_gamma}{a number specifying precision of intercept in the MNAR model. The default is 1.}

\item{n.burnin}{a positive integer indicating the number of burn-in iterations at the beginning of each chain without saving any of the posterior samples. The default is \code{floor(n.iter/2)}.}

\item{n.thin}{the thinning rate for MCMC chains, which is used to save memory and computation time when \code{n.iter} is large.
For example, the algorithm saves only one sample in every nth iteration, where n is given by \code{n.thin}.}

\item{n.adapt}{a positive integer indicating the number of iterations for adaptation. The default is 5,000.}

\item{n.iter}{a positive integer indicating the number of iterations in each MCMC chain. The default is 50,000.}

\item{n.chains}{a positive integer indicating the number of MCMC chains. The default is 3.}

\item{conv.diag}{a logical value specifying whether to compute potential scale reduction factors proposed for convergence diagnostics. The default is \code{FALSE}.}

\item{trace}{a string vector containing a subset of different quantities which can be chosen from prevalence(\code{"prev"}), sensitivity (\code{"Se"}), specificity (\code{"Sp"}), positive and negative predictive values (\code{"ppv"} and \code{"npv"} repectively), positive likelihood (\code{"LRpos"}), and negative likelihood (\code{"LRneg"}).}

\item{dic}{a logical value indicating whether the function will output the deviance information criterion (DIC) statistic. The default is \code{false}.}

\item{mcmc.samples}{a logical value indicating whether the coda samples generated in the meta-analysis. The default is \code{FALSE}.}
}
\value{
A list with the raw output for graphing the results, the effect size estimates, which lists the posterior mean, standard deviation, median, and a $95$\% equal tail credible interval for the median.
}
\description{
\code{nmadt.hierarchical.MNAR} performs meta-analysis using the hierarchical model \insertCite{Ma2018}{NMADTA} based on the missing not at random(MNAR) assumption.
}
\note{
This example uses a small number of MCMC iterations (n.iter = 1000) for demonstration.
For real-world analyses, longer chains (e.g., n.iter = 50000) are recommended
to achieve convergence and stable posterior summaries.
}
\examples{
data(dat.kang)
set.seed(9)
kang.out <- nmadt.hierarchical.MNAR(nstu = 12, K = 2, data = dat.kang,
                                   directory = tempdir(), 
                                   testname = c("D-dimer", "Ultrasonography"),
                                   n.adapt = 1000, n.iter = 1000, n.chains = 3,
                                   gamma1=c(-0.5,-0.5), gamma0=c(-0.5,-0.5))
}
\references{
\insertRef{Ma2018}{NMADTA}
}
\keyword{Test}
