test_that("norma_gene errors if conditions is missing",{
  data(multi_cond_data)

  expect_error(
    norma_gene(data=multi_cond_data, replicates="Sample_id"),
    "`conditions` must be explicitly specified"
  )
})

test_that("norma_gene errors if replicates is missing",{
  data(multi_cond_data)

  expect_error(
    norma_gene(data=multi_cond_data, conditions="Diagnosis"),
    "`replicates` must be explicitly specified"
  )
})

test_that("norma_gene returns a norma_gene object",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  expect_s3_class(res, "norma_gene")
  expect_true(is.data.frame(res))
})

test_that("norma_gene preserves non-expression metadata",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  expect_identical(res$Sample_id, multi_cond_data$Sample_id)
  expect_identical(res$Diagnosis, multi_cond_data$Diagnosis)
})
