% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyRayleigh.r
\name{LindleyRayleigh}
\alias{LindleyRayleigh}
\alias{dlindley.rlh}
\alias{plindley.rlh}
\alias{qlindley.rlh}
\alias{rlindley.rlh}
\alias{hlindley.rlh}
\title{Lindley-Rayleigh Distribution}
\usage{
dlindley.rlh(x, alpha, theta, log = FALSE)
plindley.rlh(q, alpha, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.rlh(p, alpha, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.rlh(n, alpha, theta)
hlindley.rlh(x, alpha, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.rlh}: numeric vector of (log-)densities
  \item \code{plindley.rlh}: numeric vector of probabilities
  \item \code{qlindley.rlh}: numeric vector of quantiles
  \item \code{rlindley.rlh}: numeric vector of random variates
  \item \code{hlindley.rlh}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley-Rayleigh distribution.
}
\details{
The Lindley-Rayleigh distribution is parameterized by the parameters
\eqn{\alpha > 0}, and \eqn{\theta > 0}.


The Lindley-Rayleigh distribution has CDF:

\deqn{
F(x; \alpha, \theta) =
\left[1-e^{-\alpha x^2}\right]^\theta\left\{1-\left(\frac{\theta}
{1+\theta}\right) \ln \left(1-e^{-\alpha x^2}\right)\right\} \quad ;\;x > 0.
}

where\eqn{\alpha} and \eqn{\theta} are the parameters.

Included functions are:
\itemize{
  \item \code{dlindley.rlh()} — Density function
  \item \code{plindley.rlh()} — Distribution function
  \item \code{qlindley.rlh()} — Quantile function
  \item \code{rlindley.rlh()} — Random generation
  \item \code{hlindley.rlh()} — Hazard function
}
}
\examples{
x <- seq(0.5, 5, 0.25)
dlindley.rlh(x, 0.25, 1.5)
plindley.rlh(x, 0.25, 1.5)
qlindley.rlh(0.75, 0.25, 1.5)
rlindley.rlh(10, 0.25, 1.5)
hlindley.rlh(x, 0.25, 1.5)

# Data
x <- rainfall
# ML estimates
params = list(alpha=0.2170, theta=1.2107)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.rlh, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.rlh, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.rlh, pfun=plindley.rlh, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2020). 
New Lindley-Rayleigh Distribution with Statistical properties and Applications. 
\emph{International Journal of Mathematics Trends and Technology (IJMTT)}, 
\bold{66(9)}, 197--208.  
\doi{10.14445/22315373/IJMTT-V66I9P523}
}
