% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{octo900.presentTemporal}
\alias{octo900.presentTemporal}
\title{Present Temporal stimuli on O900 (internal use)}
\arguments{
\item{stim}{Stimulus to present (a list, see details).}

\item{nextStim}{The stimulus to present after stim
(it is not presented, but projector can move to it during response window)}
}
\value{
A list containing
\itemize{
\item \code{err}  String message or NULL for no error.
\item \code{seen} 1 if seen, 0 otherwise.
\item \code{time} Reaction time (if seen).
}
}
\description{
Implementation of opiPresent for Temporal stimuli on the Octopus090 machine.

This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} with
these Arguments (\code{stim} as class \code{opiTemporalStimulus})
and you will get the Value back.
}
\details{
\code{stim} is a list containing at least the following 3 elements:
\itemize{
\item \code{x}, x-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{y}, y-coordinate in degrees (floating point) (range $[-30,30]$).
\item \code{rate} is frequency in Hz.
}

It can also contain:
\itemize{
\item \code{responseWindow} from start of stimulus presentation in milliseconds (default is 1500).
\item \code{duration} of stimulus on in milliseconds (default 200).
\item \code{size} of stimulus diameter in degrees (default Size III == 0.43).
This is rounded to the nearest support Goldmann size.
}

If stim is null, always return \code{err = NULL} status.
}
