% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseInObservation.R
\name{summariseInObservation}
\alias{summariseInObservation}
\title{Summarise the number of people in observation during a specific interval of
time}
\usage{
summariseInObservation(
  observationPeriod,
  interval = "overall",
  output = "record",
  ageGroup = NULL,
  sex = FALSE,
  dateRange = NULL
)
}
\arguments{
\item{observationPeriod}{An observation_period omop table. It must be part of
a cdm_reference object.}

\item{interval}{Time interval to stratify by. It can either be "years",
"quarters", "months" or "overall".}

\item{output}{Output format. It can be either the number of records
("record") that are in observation in the specific interval of time, the
number of person-days ("person-days"), the number of subjects ("person"),
the number of females ("sex") or the median age of population in observation
("age").}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
