# logo

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.7.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "oxford.png",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        theme = bslib::bs_theme(brand = TRUE),
        shiny::tags$style(HTML(
          ".sticky-top-btn {
            position: sticky;
            top: 0;
            z-index: 20;
            background: var(--bs-body-bg);
          }"
        )),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("book-atlas"),
          backgroundCard("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          bslib::card(
            bslib::card_header("Explore results"),
            shiny::tags$div(
              class = "mb-2",
              shinyTree::shinyTree("summary_cdm_name", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_packages", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_min_cell_count", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_panels", theme = "proton", themeIcons = FALSE)
            ),
            full_screen = TRUE
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.7.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# empty shiny

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.7.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        theme = bslib::bs_theme(brand = TRUE),
        shiny::tags$style(HTML(
          ".sticky-top-btn {
            position: sticky;
            top: 0;
            z-index: 20;
            background: var(--bs-body-bg);
          }"
        )),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("book-atlas"),
          backgroundCard("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          bslib::card(
            bslib::card_header("Explore results"),
            shiny::tags$div(
              class = "mb-2",
              shinyTree::shinyTree("summary_cdm_name", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_packages", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_min_cell_count", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_panels", theme = "proton", themeIcons = FALSE)
            ),
            full_screen = TRUE
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.7.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(server, sep = "\n")
    Output
      # Generated by OmopViewer 0.7.0
      # Be careful editing this file
      
      server <- function(input, output, session) {
        # summary ----
        output$summary_cdm_name <- shinyTree::renderTree(summaryCdmName(data))
        output$summary_packages <- shinyTree::renderTree(summaryPackages(data))
        output$summary_min_cell_count <- shinyTree::renderTree(summaryMinCellCount(data))
        output$summary_panels <- shinyTree::renderTree(summaryPanels(data))
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            data |>
              omopgenerics::bind() |>
              omopgenerics::exportSummarisedResult(
                fileName = file, logFile = NULL, logSqlPath = NULL
              )
          }
        )
      }

# title

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.7.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          "example"
        ),
        theme = bslib::bs_theme(brand = TRUE),
        shiny::tags$style(HTML(
          ".sticky-top-btn {
            position: sticky;
            top: 0;
            z-index: 20;
            background: var(--bs-body-bg);
          }"
        )),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("book-atlas"),
          backgroundCard("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          bslib::card(
            bslib::card_header("Explore results"),
            shiny::tags$div(
              class = "mb-2",
              shinyTree::shinyTree("summary_cdm_name", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_packages", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_min_cell_count", theme = "proton", themeIcons = FALSE),
              shinyTree::shinyTree("summary_panels", theme = "proton", themeIcons = FALSE)
            ),
            full_screen = TRUE
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.7.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

