% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dicot_MethPred.R
\name{Dicot_MethPred}
\alias{Dicot_MethPred}
\title{DNA Methylation Prediction in Dicot Plants}
\usage{
Dicot_MethPred(fasta_file_path, Reference = "Arabidopsis")
}
\arguments{
\item{fasta_file_path}{Sequence file (.fasta format)}

\item{Reference}{Arabidopsis as Reference Model for Dicot plants}
}
\value{
Methylation Status: Sequences with their probable DNA methylation state such as 4mC, 6mA or Non Methhylated.
}
\description{
Predicting sequences with DNA methylation sites like 4mC or 6mA based on Arabidopsis as reference model.
}
\examples{
\donttest{
library(OpEnCAST)
data<-system.file("exdata/test.fasta", package = "OpEnCAST")
pred<-Dicot_MethPred(fasta_file_path=data, Reference="Arabidopsis")
}

}
\references{
Lv, H., Dao, F. Y., Zhang, D., Guan, Z. X., Yang, H., Su, W., ... & Lin, H. (2020). iDNA-MS: an integrated computational tool for detecting DNA modification sites in multiple genomes. Iscience, 23(4).
}
