% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{fit_copulas}
\alias{fit_copulas}
\alias{fit_all_orders}
\title{Fit the copulas of a PCBN given data}
\usage{
fit_copulas(
  data,
  DAG,
  order_hash,
  familyset = c(1, 3, 4, 5, 6),
  familyMatrix = NULL,
  e,
  verbose = 1,
  method = "mle"
)

fit_all_orders(
  data,
  DAG,
  familyset = c(1, 3, 4, 5, 6),
  e,
  score_metric = "BIC",
  verbose = 1
)
}
\arguments{
\item{data}{data frame}

\item{DAG}{Directed Acyclic Graph}

\item{order_hash}{hashmap of parental orders}

\item{familyset}{vector of copula families}

\item{familyMatrix}{matrix of families, with named rows and columns.
This should be used if the copula families are known/fixed.
This overrides \code{familyset}.}

\item{e}{environment containing all the hashmaps}

\item{verbose}{if \code{0}, don't print anything.
If \code{verbose >= 1}, print information about the simulation procedure.}

\item{method}{indicates the estimation method (\code{"mle"} for maximum
likelihood estimation or \code{"itau"} of inversion of Kendall's tau).}

\item{score_metric}{name of the metric used to choose the best order.
Possible choices are \code{logLik}, \code{AIC} and \code{BIC}.}
}
\value{
\code{fit_copulas} returns the fitted PCBN, with an additional
element called \code{metrics} which is a named vector of length 3 with names
\code{c("logLik", "BIC", "AIC")}, where
\eqn{AIC = - 2 * logLik + 2 * nparameters}
and \eqn{BIC = - 2 * logLik + log(n) * nparameters},
for a sample size \code{n} and \code{nparameters} is the number of parameters.

\code{fit_all_orders} returns a list containing: \itemize{
  \item \code{best_fit} the PCBN which is the best according to the metric
  \code{score_metric}.

  \item \code{fitted_list} the list of all fitted PCBNs.

  \item \code{metrics} the matrix of metrics (logLik, BIC, AIC).
  Each row \code{i} of this matrix corresponds to a PCBN with a different set
  of parents' orderings, and corresponds to element \code{i} of
  \code{fitted_list}.
}
}
\description{
Fit the copulas of a PCBN given data

Fit all possible orders given a DAG
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)

tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

mydata = PCBN_sim(my_PCBN, N = 5)
e = default_envir()

result = fit_copulas(data = mydata, DAG = DAG,
                     order_hash = order_hash,
                     familyset = 1, e = e)

result_all_orders = fit_all_orders(data = mydata, DAG = DAG,
                                   familyset = 1, e = e)

# The two fitted PCBNs are:
print(result_all_orders$fitted_list[[1]])
print(result_all_orders$fitted_list[[2]])
# and the metrics matrix is:
print(result_all_orders$metrics)

# The PCBN corresponding to the true order U1 < U2 is usually better
# than the second one. This Will be more clear with a bigger sample size.


}
\seealso{
\code{\link{BiCopCondFit}} which this function wraps.
}
