% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSTR.R
\name{NewPSTR}
\alias{NewPSTR}
\title{Create a PSTR model object}
\usage{
NewPSTR(data, dep, indep, indep_k = NULL, tvars, im = 1, iT)
}
\arguments{
\item{data}{A tibble containing the panel in long format. The number of rows must be
\code{iT * N} for some integer \code{N}. Rows are assumed to be ordered by time within
individual, consistently with the package conventions.}

\item{dep}{A single column index or a single column name specifying the dependent variable.}

\item{indep}{A vector of column indices or column names specifying the regressors in the
linear part.}

\item{indep_k}{Optional. A vector of column indices or column names specifying the regressors
in the non-linear part. If \code{NULL}, the non-linear part is set equal to the linear part.}

\item{tvars}{A vector of column indices or column names specifying the candidate transition
variables.}

\item{im}{Integer. The maximal number of switches used in linearity-related tests.
Default is \code{1}.}

\item{iT}{Integer. The time dimension (number of time observations per individual).}
}
\value{
An R6 object of class \code{"PSTR"}.
}
\description{
Create an R6 object of class \code{"PSTR"} to be used as the main container for
Panel Smooth Transition Regression (PSTR) modelling in this package.
You typically call \code{NewPSTR()} once, and then pass the returned object to
specification, estimation and evaluation functions.
}
\details{
The candidate transition variables in \code{tvars} will be stored in the object
and can be tested one by one by functions such as \code{\link{LinTest}}.

Missing values in the dependent variable, linear regressors, non-linear regressors,
or transition variables are removed internally (row-wise).
The number of individuals \eqn{N} is inferred from \code{nrow(data)} and \code{iT}
after removing missing values.
}
\examples{
\donttest{
pstr <- NewPSTR(
  Hansen99,
  dep = "inva",
  indep = 4:20,
  indep_k = c("vala", "debta", "cfa", "sales"),
  tvars = c("vala", "debta"),
  iT = 14
)

# print summary (your R6 print method)
pstr
print(pstr, mode = "summary")

# after running tests/estimation, you can print other sections
# print(pstr, mode = "tests")
# print(pstr, mode = "estimates")
# print(pstr, mode = "evaluation")
}

}
\seealso{
\code{\link{LinTest}}, \code{\link{WCB_LinTest}}, \code{\link{EstPSTR}},
  \code{\link{EvalTest}}, \code{\link{WCB_TVTest}}, \code{\link{WCB_HETest}}.
}
\keyword{initialization}
