% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U01-data-validation.R
\name{validate_method_arguments}
\alias{validate_method_arguments}
\title{Validate Method Arguments}
\usage{
validate_method_arguments(
  weight_method,
  censor_method,
  trim_alpha,
  trim_q,
  time_points,
  conf_level,
  ps_control,
  censor_control,
  bootstrap_control,
  max_time
)
}
\arguments{
\item{weight_method}{Character string specifying weighting method.}

\item{censor_method}{Character string specifying censoring method.}

\item{trim_alpha}{Numeric, symmetric trimming threshold.}

\item{trim_q}{Numeric, asymmetric trimming quantile.}

\item{time_points}{Numeric vector or NULL.}

\item{conf_level}{Numeric, confidence level.}

\item{ps_control}{List of PS model control parameters.}

\item{censor_control}{List of censoring model control parameters.}

\item{bootstrap_control}{List of bootstrap control parameters or NULL.}

\item{max_time}{Numeric, maximum observed time (to check time_points range).}
}
\value{
Invisible NULL if checks pass; otherwise throws an error.
}
\description{
Validates weight_method, censor_method, trimming parameters, time_points,
and control lists. Synthesizes all method-specific checks.
}
\keyword{internal}
