% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helping_functions.R
\name{create_readable_summary}
\alias{create_readable_summary}
\title{Create readable summary of PTSD diagnostic changes}
\usage{
create_readable_summary(summary_stats)
}
\arguments{
\item{summary_stats}{A dataframe output from summarize_ptsd_changes()
containing raw diagnostic metrics and counts}
}
\value{
A formatted dataframe with the following columns:

\itemize{
  \item  Scenario: Name of the diagnostic criterion
  \item  Total Diagnosed: Count and percentage of diagnosed cases
  \item  Total Non-Diagnosed: Count and percentage of non-diagnosed cases
  \item  True Positive: Count of cases diagnosed under both criteria
  \item  True Negative: Count of cases not diagnosed under either criterion
  \item  Newly Diagnosed: Count of new positive diagnoses (false positive)
  \item  Newly Non-Diagnosed: Count of new negative diagnoses (false negative)
  \item  True Cases: Total correctly classified cases
  \item  False Cases: Total misclassified cases
  \item  Sensitivity, Specificity, PPV, NPV: Diagnostic accuracy metrics (4 decimals)
}
}
\description{
Formats the output of summarize_ptsd_changes() into a more readable table
with proper labels and formatting of percentages and metrics.
}
\details{
Reformats the diagnostic metrics into a presentation-ready format:

\itemize{
\item  Combines counts with percentages for diagnosed/non-diagnosed cases
\item  Rounds diagnostic accuracy metrics to 4 decimal places
\item  Provides clear column headers for all metrics
}
}
\examples{
# Using the output from summarize_ptsd_changes
n_cases <- 100
sample_data <- data.frame(
  PTSD_orig = sample(c(TRUE, FALSE), n_cases, replace = TRUE),
  PTSD_alt1 = sample(c(TRUE, FALSE), n_cases, replace = TRUE)
)

# Generate and format summary
diagnostic_metrics <- summarize_ptsd_changes(sample_data)
readable_summary <- create_readable_summary(diagnostic_metrics)
print(readable_summary)

}
