% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_low_api.R
\name{work_group}
\alias{work_group}
\alias{create_work_group}
\alias{tag_options}
\alias{delete_work_group}
\alias{list_work_groups}
\alias{get_work_group}
\alias{update_work_group}
\title{Athena Work Groups}
\usage{
create_work_group(
  conn,
  work_group = NULL,
  enforce_work_group_config = FALSE,
  publish_cloud_watch_metrics = FALSE,
  bytes_scanned_cut_off = 10000000L,
  requester_pays = FALSE,
  description = NULL,
  tags = tag_options(key = NULL, value = NULL)
)

tag_options(key = NULL, value = NULL)

delete_work_group(conn, work_group = NULL, recursive_delete_option = FALSE)

list_work_groups(conn)

get_work_group(conn, work_group = NULL)

update_work_group(
  conn,
  work_group = NULL,
  remove_output_location = FALSE,
  enforce_work_group_config = FALSE,
  publish_cloud_watch_metrics = FALSE,
  bytes_scanned_cut_off = 10000000L,
  requester_pays = FALSE,
  description = NULL,
  state = c("ENABLED", "DISABLED"),
  engine_version = list()
)
}
\arguments{
\item{conn}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{work_group}{The Athena workgroup name.}

\item{enforce_work_group_config}{If set to \code{TRUE}, the settings for the workgroup override client-side settings.
If set to \code{FALSE}, client-side settings are used. For more information, see
\href{https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html}{Workgroup Settings Override Client-Side Settings}.}

\item{publish_cloud_watch_metrics}{Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.}

\item{bytes_scanned_cut_off}{The upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan.}

\item{requester_pays}{If set to \code{TRUE}, allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries.
If set to \code{FALSE}, workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data
from Requester Pays buckets cause an error. The default is false. For more information about Requester Pays buckets,
see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html}{Requester Pays Buckets} in the Amazon Simple Storage Service Developer Guide.}

\item{description}{The workgroup description.}

\item{tags}{A tag that you can add to a resource. A tag is a label that you assign to an AWS Athena resource (a workgroup).
Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize workgroups in Athena, for example,
by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter workgroups in your account.
The maximum tag key length is 128 Unicode characters in UTF-8. The maximum tag value length is 256 Unicode characters in UTF-8.
You can use letters and numbers representable in UTF-8, and the following characters: \code{"+ - = . _ : / @"}. Tag keys and values are case-sensitive.
Tag keys must be unique per resource. Please use the helper function \code{tag_options()} to create tags for work group, if no tags are required please put \code{NULL} for this parameter.}

\item{key}{A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: \code{"+ - = . _ : / @"}.
Tag keys are case-sensitive and must be unique per resource.}

\item{value}{A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You can use letters and numbers representable in UTF-8, and the following characters: \code{"+ - = . _ : / @"}.
Tag values are case-sensitive.}

\item{recursive_delete_option}{The option to delete the workgroup and its contents even if the workgroup contains any named queries}

\item{remove_output_location}{If set to \code{TRUE}, indicates that the previously-specified query results location (also known as a client-side setting) for queries in this workgroup should be ignored and set to null.
If set to \code{FALSE} the out put location in the workgroup's result configuration will be updated with the new value.
For more information, see \href{https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html}{Workgroup Settings Override Client-Side Settings}.}

\item{state}{The workgroup state that will be updated for the given workgroup.}

\item{engine_version}{The engine version requested when a workgroup is updated.
\describe{
\item{SelectedEngineVersion}{The engine version requested by the user.}
\item{EffectiveEngineVersion}{The engine version on which the query runs.}
}}
}
\value{
\describe{
\item{create_work_group}{Returns \code{NULL} but invisible}
\item{tag_options}{Returns \code{list} but invisible}
\item{delete_work_group}{Returns \code{NULL} but invisible}
\item{list_work_groups}{Returns list of available work groups}
\item{get_work_group}{Returns list of work group meta data}
\item{update_work_group}{Returns \code{NULL} but invisible}
}
}
\description{
Lower level API access, allows user to create and delete Athena Work Groups.
\describe{
\item{create_work_group}{Creates a workgroup with the specified name (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/athena.html#Athena.Client.create_work_group}{link}).
The work group utilises parameters from the \code{dbConnect} object, to determine the encryption and output location of the work group.
The s3_staging_dir, encryption_option and kms_key parameters are gotten from \code{\link{dbConnect}}}
\item{tag_options}{Helper function to create tag options for function \code{create_work_group()}}
\item{delete_work_group}{Deletes the workgroup with the specified name (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/athena.html#Athena.Client.delete_work_group}{link}).
The primary workgroup cannot be deleted.}
\item{list_work_groups}{Lists available workgroups for the account (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/athena.html#Athena.Client.list_work_groups}{link}).}
\item{get_work_group}{Returns information about the workgroup with the specified name (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/athena.html#Athena.Client.get_work_group}{link}).}
\item{update_work_group}{Updates the workgroup with the specified name (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/athena.html#Athena.Client.update_work_group}{link}).
The workgroup's name cannot be changed. The work group utilises parameters from the \code{dbConnect} object, to determine the encryption and output location of the work group.
The s3_staging_dir, encryption_option and kms_key parameters are gotten from \code{\link{dbConnect}}}
}
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(RAthena)

# Demo connection to Athena using profile name
con <- dbConnect(RAthena::athena())

# List current work group available
list_work_groups(con)

# Create a new work group
wg <- create_work_group(con,
                  "demo_work_group",
                   description = "This is a demo work group",
                   tags = tag_options(key= "demo_work_group", value = "demo_01"))

# List work groups to see new work group
list_work_groups(con)

# get meta data from work group
wg <- get_work_group(con, "demo_work_group")

# Update work group
wg <- update_work_group(con, "demo_work_group",
                  description = "This is a demo work group update")


# get updated meta data from work group
wg <- get_work_group(con, "demo_work_group")

# Delete work group
delete_work_group(con, "demo_work_group")

# Disconect from Athena
dbDisconnect(con)
}

}
