% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HuberSpline.R
\name{HuberSpline}
\alias{HuberSpline}
\title{Huber (1974) Minimal Fisher (location) information spline via conic optimization}
\usage{
HuberSpline(x, p, grid, kappa = 0)
}
\arguments{
\item{x}{quantiles to be interpolated}

\item{p}{probabilities associated with x}

\item{grid}{grid values for fitted object}

\item{kappa}{width of Kolmogorov neighborhood}
}
\value{
An object of class density with solution \eqn{f*}
}
\description{
\deqn{\min \sum \frac{(f_{i+1}-f_i )^2}{( f_{i+1}+f_i )/2} = \sum \frac{u_i^2}{v_i/2} \approx I(F)}
}
\details{
\deqn{\Leftrightarrow  \quad  \min \sum w_i \;  \mbox{s.t.} \;  u_i^2  \leq 2 v_i w_i}

  subject to interpolation of constraints \eqn{F(x_j) = p_j, \;  j=1,...,n.}  
  When \eqn{\kappa > 0}, \eqn{I(F)} is minimized within a Kolmogorov neighborhood 
  of the constraint points, rather than interpolating them.
  The generalization to Kolmogorov neighborhoods is due to Donoho
  and Reeves (2013).

  N.B.  When the grid is not equispaced, one would have to include grid spacings.
}
\references{
P. J. Huber. (1974) "Fisher Information and Spline Interpolation." 
Ann. Statist. 2 (5) 1029 - 1033,  

D. L. Donoho and G. Reeves, (2013) Achieving Bayes MMSE Performance in the Sparse Signal 
Gaussian White Noise Model when the Noise Level is Unknown, Proc. IEEE Symposium Istanbul, Turkey.
}
\author{
R. Koenker and J. Gu
}
\keyword{nonparametric}
