% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-survey-link-export-oneshot.R
\name{redcap_survey_link_export_oneshot}
\alias{redcap_survey_link_export_oneshot}
\title{Get survey link from REDCap}
\usage{
redcap_survey_link_export_oneshot(
  redcap_uri,
  token,
  record,
  instrument,
  event = "",
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{record}{The record ID associated with the
survey link. Required}

\item{instrument}{The name of the instrument associated with the
survey link.  Required}

\item{event}{The name of the event associated with the
survey link.
Optional}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements,
\itemize{
\item \code{survey_link}: a character string containing the URL for the survey.
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{instrument}: The instrument associated with the survey link.
\item \code{records_affected_count}: The number of records associated with
the survey link.
\item \code{affected_ids}: The subject IDs associated with the survey link.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
This function uses REDCap's API to get the link for a survey.
}
\details{
Currently, the function doesn't modify any variable types to conform to
REDCap's supported variables.  See \code{\link[=validate_for_write]{validate_for_write()}} for a helper
function that checks for some common important conflicts.

\strong{Permissions Required}
To use this method, you must have API Export privileges in the project.
(As stated in the 9.0.0 documentation.)
}
\examples{
\dontrun{
uri     <- "https://redcap-dev-2.ouhsc.edu/redcap/api/"
token   <- "4780D038A2080BA2E7CC904A14218662" # survey

record  <- 1
instrument   <- "participant_morale_questionnaire"
# event <- "" # only for longitudinal projects

result <- REDCapR::redcap_survey_link_export_oneshot(
  record         = record,
  instrument     = instrument,
  redcap_uri     = uri,
  token          = token
)
result$survey_link
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
