% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remix.R
\name{remix}
\alias{remix}
\title{REMixed algorithm}
\usage{
remix(
  project = NULL,
  final.project = NULL,
  dynFUN,
  y,
  ObsModel.transfo,
  alpha,
  lambda,
  eps1 = 10^(-2),
  eps2 = 10^(-1),
  selfInit = FALSE,
  pop.set1 = NULL,
  pop.set2 = NULL,
  pop.set3 = NULL,
  prune = NULL,
  n = NULL,
  parallel = TRUE,
  ncores = NULL,
  print = TRUE,
  verbose = FALSE,
  digits = 3,
  trueValue = NULL,
  finalSAEM = FALSE,
  test = TRUE,
  max.iter = +Inf,
  p.max = 0.05
)
}
\arguments{
\item{project}{directory of the Monolix project (in .mlxtran). If NULL, the current loaded project is used (default is NULL).}

\item{final.project}{directory of the final Monolix project (default add "_upd" to the Monolix project).}

\item{dynFUN}{function computing the dynamics of interest for a set of parameters. This function need to contain every sub-function that it may needs (as it is called in a \code{foreach} loop). The output of this function need to return a data.frame with \code{time} as first columns and named dynamics in other columns. It must take in input : \describe{\item{\code{y}}{a named vector with the initial condition. The names are the dynamics names.}
\item{\code{parms}}{a named vector of parameter.}
\item{\code{time}}{vector a timepoint.}}

See \code{\link{dynFUN_demo}}, \code{\link{model.clairon}}, \code{\link{model.pasin}} or \code{\link{model.pk}} for examples.}

\item{y}{initial condition of the mechanism model, conform to what is asked in dynFUN. If regressor used in Monolix provided a named list of vector of individual initial conditions. Each vector need to be of length 1 (same for all), or exactly the numbre of individuals (range in the same order as their id).}

\item{ObsModel.transfo}{list containing two lists of transformations and two vectors linking each transformations to their observation model name in the Monolix project. The list should include identity transformations and be named \code{S} and \code{R}. The two vectors should be named \code{linkS} and \code{linkR}.

Both \code{S} (for the direct observation models) and \code{linkS}, as well as \code{R} (for latent process models) and \code{linkR}, must have the same length.

\describe{
  \item{\code{S}}{a list of transformations for the direct observation models. Each transformation corresponds to a variable \eqn{Y_p=h_p(S_p)}, where the name indicates which dynamic is observed (from \code{dynFUN});}\item{\code{linkS}}{a vector specifying the observation model names (that is used in the monolix project, \code{alpha1}, etc.) for each transformation, in the same order as in \code{S};}

  \item{\code{R}}{similarly, a list of transformations for the latent process models. Although currently there is only one latent dynamic, each \eqn{s_k, k\leq K} transformation corresponds to the same dynamic but may vary for each \eqn{Y_k} observed. The names should match the output from \code{dynFUN};} \item{\code{linkR}}{a vector specifying the observation model names for each transformation, in the same order as in \code{R}.}
}}

\item{alpha}{named list of named vector "\code{alpha0}", "\code{alpha1}" (all \code{alpha1} are mandatory). The name of \code{alpha$alpha0} and \code{alpha$alpha1} are the observation model names from the monolix project to which they are linked (if the observations models are defined whithout intercept, alpha$alpha0 need to be set to the vector NULL).}

\item{lambda}{penalization parameter \eqn{\lambda}.}

\item{eps1}{integer (>0) used to define the convergence criteria for the regression parameters.}

\item{eps2}{integer (>0) used to define the convergence criteria for the likelihood.}

\item{selfInit}{logical, if the SAEM is already done in the monolix project should be use as the initial point of the algorithm (if FALSE, SAEM is automatically compute according to \code{pop.set1} settings ; if TRUE, a SAEM through monolix need to have been launched).}

\item{pop.set1}{population parameters setting for initialisation (see details).}

\item{pop.set2}{population parameters setting for iterations.}

\item{pop.set3}{population parameters setting for final estimation.}

\item{prune}{percentage for prunning (\eqn{\in[0;1]})  in the Adaptative Gauss-Hermite algorithm used to compute the log-likelihood and its derivates (see \code{\link{gh.LL}}).}

\item{n}{number of points for  gaussian quadrature (see \code{\link{gh.LL}}).}

\item{parallel}{logical, if the computation should be done in parallel when possible (default TRUE).}

\item{ncores}{number of cores for parallelization (default NULL and \code{\link{detectCores}} is used).}

\item{print}{logical, if the results and algotihm steps should be displayed in the console (default to TRUE).}

\item{verbose}{logical, if progress bar should be printed when possible.}

\item{digits}{number of digits to print (default to 3).}

\item{trueValue}{-for simulation purposes- named vector of true value for parameters.}

\item{finalSAEM}{logical, if a final SAEM should be launch with respect to the final selected set.}

\item{test}{if Wald test should be computed at the end of the iteration.}

\item{max.iter}{maximum number of iterations (default 20).}

\item{p.max}{maximum value to each for wald test p.value (default 0.05).}
}
\value{
a list of outputs of final project and through the iteration : \describe{\item{\code{info}}{informations about the parameters (project path, regulatization and population parameter names, alpha names, value of lambda used, if final SAEM and test has been computed, parameters p.max and \eqn{N}) ;}\item{\code{finalRes}}{containing loglikelihood \code{LL} and penalized loglikelihood \code{LL.pen} values, final population parameters \code{param} and final regularization parameters \code{alpha} values, number of iterations \code{iter} and \code{time} needed , if computed, the estimated standard errors \code{standardError} and if test computed, the final results before test \code{saemBeforeTest} ;}\item{\code{iterOutputs}}{the list of all remix outputs, i.e. parameters, lieklihood, SAEM estimates and convergence criterion value over the iteration.}}
}
\description{
Regularization and Estimation in Mixed effects model.
}
\details{
See \code{\link{REMixed-package}} for details on the model.
For population parameter estimation settings, see (<https://monolixsuite.slp-software.com/r-functions/2024R1/setpopulationparameterestimationsettings>).
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)
lambda = 382.22

res = remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            eps2=1,
            lambda=lambda)

summary(res)

trueValue = read.csv(paste0(dirname(project),"/demoSMLX/Simulation/populationParameters.txt"))

plotSAEM(res,paramToPlot = c("delta_S_pop","phi_S_pop","delta_AB_pop"),trueValue=trueValue)
}
}
\seealso{
\code{\link{cv.remix}}.
}
