% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sym.PCA.Hist.PCA.k.plot.r
\name{Sym.PCA.Hist.PCA.k.plot}
\alias{Sym.PCA.Hist.PCA.k.plot}
\title{Sym.PCA.Hist.PCA.k.plot}
\usage{
Sym.PCA.Hist.PCA.k.plot(
  data.sym.df,
  title.graph,
  concepts.name,
  title.x,
  title.y,
  pca.axes
)
}
\arguments{
\item{data.sym.df}{Bins's projections}

\item{title.graph}{Plot title}

\item{concepts.name}{Concepts names}

\item{title.x}{Label of axis X}

\item{title.y}{Label of axis Y}

\item{pca.axes}{Principal Component}
}
\value{
Concepts projected onto the Principal component chosen
}
\description{
Sym.PCA.Hist.PCA.k.plot
}
\examples{
\dontrun{
data("hardwoodBrito")
Hardwood.histogram<-hardwoodBrito
Hardwood.cols<-colnames(Hardwood.histogram)
Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
Hardwood.quantiles.PCA<-quantiles.RSDA(pca.hist$sym.hist.matrix.PCA,3)
ACER.p1<-Sym.PCA.Hist.PCA.k.plot(data.sym.df = pca.hist$Bins.df,
                                    title.graph = " ",
                                    concepts.name = c("ACER"),
                                    title.x = "First Principal Component (84.83\%)",
                                    title.y = "Frequency",
                                    pca.axes = 1)

ACER.p1
}
}
\author{
Jorge Arce Garro
}
