% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{cgaussian}
\alias{cgaussian}
\title{Gaussian copula constructor}
\usage{
cgaussian(rho = 0)
}
\arguments{
\item{rho}{Correlation parameter (\eqn{-1 < rho < 1}).}
}
\value{
Function of two arguments (u,v) returning log copula density.

The Gaussian copula density is
\deqn{
c(u,v;\rho) = \frac{1}{\sqrt{1-\rho^2}}
\exp\left\{-\frac{1}{2(1-\rho^2)} (z_1^2 - 2 \rho z_1 z_2 + z_2^2) + \frac{1}{2}(z_1^2 + z_2^2) \right\},
}
where \eqn{z_1 = \Phi^{-1}(u)}, \eqn{z_2 = \Phi^{-1}(v)}, and \eqn{-1 < \rho < 1}.
}
\description{
Returns a function computing the log density of the bivariate Gaussian copula,
intended to be used with \code{\link{dcopula}}.
}
\examples{
x <- c(0.5, 1); y <- c(1, 2)
d1 <- dnorm(x, 1, log = TRUE); d2 <- dexp(y, 2, log = TRUE)
p1 <- pnorm(x, 1); p2 <- pexp(y, 2)
dcopula(d1  , d2, p1, p2, copula = cgaussian(0.5), log = TRUE)
}
\seealso{
\code{\link[=cclayton]{cclayton()}}, \code{\link[=cgumbel]{cgumbel()}}, \code{\link[=cfrank]{cfrank()}}
}
