% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoibeta2.R
\name{zoibeta2}
\alias{zoibeta2}
\alias{dzoibeta2}
\alias{pzoibeta2}
\alias{rzoibeta2}
\title{Reparameterised zero- and one-inflated beta distribution}
\usage{
dzoibeta2(x, mu, phi, zeroprob = 0, oneprob = 0, log = FALSE)

pzoibeta2(q, mu, phi, zeroprob = 0, oneprob = 0,
         lower.tail = TRUE, log.p = FALSE)

rzoibeta2(n, mu, phi, zeroprob = 0, oneprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{mean parameter, must be in the interval from 0 to 1.}

\item{phi}{concentration parameter, must be positive.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{oneprob}{zero-inflation probability between 0 and 1.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dzoibeta2} gives the density, \code{pzoibeta2} gives the distribution function, and \code{rzoibeta2} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-one-inflated beta distribution reparameterised in terms of mean and concentration.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzoibeta2(1, 0.6, 2, 0.2, 0.3)
d <- dzoibeta2(x, 0.6, 2, 0.2, 0.3)
p <- pzoibeta2(x, 0.6, 2, 0.2, 0.3)
}
