% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcpe.R
\name{bcpe}
\alias{bcpe}
\alias{dbcpe}
\alias{pbcpe}
\alias{qbcpe}
\alias{rbcpe}
\title{Box-Cox Power Exponential distribution (BCPE)}
\usage{
dbcpe(x, mu = 5, sigma = 0.1, nu = 1, tau = 2, log = FALSE)

pbcpe(q, mu = 5, sigma = 0.1, nu = 1, tau = 2, lower.tail = TRUE, log.p = FALSE)

qbcpe(p, mu = 5, sigma = 0.1, nu = 1, tau = 2, lower.tail = TRUE, log.p = FALSE)

rbcpe(n, mu = 5, sigma = 0.1, nu = 1, tau = 2)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter, must be positive.}

\item{sigma}{scale parameter, must be positive.}

\item{nu}{vector of \code{nu} parameter values.}

\item{tau}{vector of \code{tau} parameter values, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dbcpe} gives the density, \code{pbcpe} gives the distribution function, \code{qbcpe} gives the quantile function, and \code{rbcpe} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Box-Cox Power Exponential distribution.
}
\details{
This implementation of \code{dbcpe} and \code{pbcpe} allows for automatic differentiation with \code{RTMB} while the other functions are imported from \code{gamlss.dist} package.
See \code{gamlss.dist::\link[gamlss.dist]{BCPE}} for more details.
}
\examples{
x <- rbcpe(1, mu = 5, sigma = 0.1, nu = 1, tau = 1)
d <- dbcpe(x, mu = 5, sigma = 0.1, nu = 1, tau = 1)
p <- pbcpe(x, mu = 5, sigma = 0.1, nu = 1, tau = 1)
q <- qbcpe(p, mu = 5, sigma = 0.1, nu = 1, tau = 1)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
