% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_var_function.R
\name{desc_var}
\alias{desc_var}
\title{Generate Descriptive Tables for Variables}
\usage{
desc_var(
  data1,
  table_title = "",
  quali = NULL,
  quanti = NULL,
  add_total = TRUE,
  var_title = "Variable",
  by_group = FALSE,
  var_group = NULL,
  group_title = NULL,
  digits = list(mean_sd = 1, median_q1_q3_min_max = 1, pct = 1),
  drop_levels = TRUE,
  freq_relevel = FALSE,
  tests = FALSE,
  show_n_per_group = FALSE,
  show_missing_data = NULL,
  var_tot = NULL,
  var_characteristic = NULL
)
}
\arguments{
\item{data1}{A data frame containing the dataset to be analyzed.}

\item{table_title}{A character string specifying the title of the table.}

\item{quali}{A vector of qualitative variables to be described. Defaults to \code{NULL}.}

\item{quanti}{A vector of quantitative variables to be described. Defaults to \code{NULL}.}

\item{add_total}{A boolean (default is TRUE) to add total column or not when var_group is specified.}

\item{var_title}{A character string for the title of the variable column in the table. Defaults to \code{"Variable"}.}

\item{by_group}{A boolean (default is FALSE) to analyse by group.}

\item{var_group}{A variable used for grouping (if applicable). Defaults to \code{NULL}.}

\item{group_title}{A character string specifying the title for the grouping variable. Default is \code{NULL} and get the label or the variable.}

\item{digits}{A list, the number of decimal places to round categorical and
continuous variable. Default is list(mean_sd = 1,
median_q1_q3_min_max = 1, pct = 1).}

\item{drop_levels}{Boolean (default = TRUE). Drop unused levels.}

\item{freq_relevel}{Boolean (default = FALSE). Reorder factors by frequency.}

\item{tests}{A value in order to add p value. Default to \code{FALSE} OPTION :
\itemize{
\item \code{FALSE}: No p-value add
\item \code{TRUE}: Add p-value made by default by gtsummary. See gtsummary add_p() options.
\item \code{list()}: To force tests. See gtsummary add_p() options.
}}

\item{show_n_per_group}{Default to \code{FALSE}. Should the 'N' appears in the column header of the groups. Can be either :
\itemize{
\item \code{FALSE}: No 'N' is shown
\item \code{TRUE}: 'N' is shown
}}

\item{show_missing_data}{Default to \code{NULL}. Should the missing data be displayed. Can be either :
\itemize{
\item \code{FALSE}: No missing data displayed
\item \code{TRUE}: Missing data displayed
\item \code{NULL} (default): will be switch to \code{anyNA(data1)} value.
}}

\item{var_tot}{A string specifying the name of total column. Default is \code{NULL} and will guess from \code{theme_gtsummary_language()}.}

\item{var_characteristic}{A string specifying the name of characteristic column. Default is \code{NULL} and will guess from \code{theme_gtsummary_language()}.}
}
\value{
A gtsummary table object containing the descriptive statistics.
}
\description{
This function creates descriptive tables for variables in a dataset. It can handle qualitative and quantitative variables, grouped or ungrouped, and supports multiple configurations for handling missing data (DM).
}
\details{
The function processes the dataset according to the specified parameters and generates descriptive tables.
\itemize{
\item It first uses the \code{ajouter_label_ndm()} function to append missing data statistics to variable labels.
\item Depending on the \code{group} and \code{DM} arguments, it adjusts the dataset and creates tables using helper functions like \code{desc_group}, \code{desc_degroup}, and \code{desc_degroup_group}.
\item Qualitative variables are reordered, and unused levels are dropped when necessary.
}
}
\examples{
# Example usage:
library(dplyr)

# Sample dataset
data1 <- data.frame(
  group = c("A", "B", "A", "C"),
  var1 = c(1, 2, 3, NA),
  var2 = c("X", "Y", "X", NA)
)

# Generate descriptive table
table <- desc_var(
  data1 = data1,
  table_title = "Descriptive Table"
)

}
