% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negexp.like.R
\name{negexp.like}
\alias{negexp.like}
\title{Negative exponential likelihood}
\usage{
negexp.like(a, dist, covars, w.hi = NULL)
}
\arguments{
\item{a}{A vector or matrix of covariate 
and expansion term 
coefficients. If matrix, dimension is 
\emph{k} X \emph{p}, where 
\emph{k} = \code{nrow(a)}) is the number of coefficient
vectors to evaluate (cases) and \emph{p} 
= \code{ncol(a)})
is the number of covariate and expansion 
coefficients in the likelihood (i.e., rows are 
cases and columns are covariates). If \code{a} is a 
dimensionless vector, it is interpreted as a 
single row with \emph{k} = 1. 
Covariate coefficients in \code{a} are the first 
\emph{q} values (\emph{q} <= \emph{p}), and must 
be on a log scale.}

\item{dist}{A numeric vector of length \emph{n} or 
a single-column matrix (dimension \emph{n}X1) containing 
detection distances at which to evaluate the likelihood.}

\item{covars}{A numeric vector of length \emph{q} or a
matrix of dimension \emph{n}X\emph{q} containing 
covariate values 
associated with distances in argument \code{dist}.}

\item{w.hi}{A numeric scalar containing maximum 
distance. The right-hand cutoff or upper limit. 
Ignored by some likelihoods (such as halfnorm, 
negexp, and hazrate), but is a fixed parameter
in other likelihoods (such as oneStep, heber, 
and uniform).}
}
\value{
A list containing the following two components:
\itemize{
  \item \bold{L.unscaled}: A matrix of size 
   \emph{n}X\emph{k}X\emph{b} 
   containing likelihood values evaluated at 
   distances in \code{dist}.
   Each row is associated with 
   a single distance, and each column is associated with 
   a single case (row of \code{a}).  This matrix is  
   "unscaled" because the underlying likelihood does 
   not integrate to one. Values in \code{L.unscaled} 
   are always greater than or equal to zero.
   
 \item \bold{params}: A \emph{n}X\emph{k}X\emph{b} array 
 of the 
 likelihood's (canonical) parameters. First page contains 
 parameter values related to covariates (i.e., 
 \emph{s = exp(x'a)}),
 while subsequent pages contain other parameters. 
 \emph{b} = 1 for halfnorm, negexp; \emph{b} = 2 for 
 hazrate and others.
 Rows correspond to distances in \code{dist}. Columns 
 correspond to rows from argument \code{a}. 
}
}
\description{
Computes the negative exponential distance function.
}
\details{
The negative exponential likelihood is 
\deqn{f(x|a) = \exp(-ax)}{f(x|a) = exp( -a*x )} where \eqn{a} is the 
slope parameter.
}
\examples{
d <- seq(0, 100, length=100)
covs <- matrix(1,length(d),1)
negexp.like(log(0.01), d, covs)

# Changing slope parameter
plot(d, negexp.like(log(0.1), d, covs)$L.unscaled, type="l", col="red")
lines(d, negexp.like(log(0.05), d, covs)$L.unscaled, col="blue")

}
\seealso{
\code{\link{dfuncEstim}}, 
         \code{\link{abundEstim}},
         other \code{<likelihood>.like} functions
}
