% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dfunc.para.R
\name{plot.dfunc.para}
\alias{plot.dfunc.para}
\title{Plot parametric distance functions}
\usage{
\method{plot}{dfunc.para}(
  x,
  include.zero = FALSE,
  nbins = "Sturges",
  newdata = NULL,
  legend = TRUE,
  vertLines = TRUE,
  plotBars = TRUE,
  circles = FALSE,
  density = -1,
  angle = 45,
  xlab = NULL,
  ylab = NULL,
  border = TRUE,
  col = "grey85",
  col.dfunc = NULL,
  lty.dfunc = NULL,
  lwd.dfunc = NULL,
  ...
)
}
\arguments{
\item{x}{An estimated detection function object, normally 
produced by calling \code{\link{dfuncEstim}}.}

\item{include.zero}{Boolean value specifying whether to include 0 on the x-axis 
of the plot.  A value of TRUE will include 0 on the left hand end of the x-axis
regardless of the range of distances.  A value of FALSE will plot only the
observation strip (\code{w.lo} to \code{w.hi}).}

\item{nbins}{Internally, this function uses \code{hist} to compute histogram
bars for the plot. This argument is the \code{breaks} argument to
\code{hist}.  This can be either a vector giving the breakpoints between
bars, the suggested number of bars (a single number), a string naming
an algorithm to compute the number of bars, or a function to compute the
number of bars.  See \code{\link{hist}} for all options.}

\item{newdata}{Data frame (similar to \code{newdata} parameter 
of \code{\link{lm}}) containing new values for covariates in 
the distance function.
One distance function is computed and plotted for each row in the data frame. 
If \code{newdata} is NULL, a single distance function is plotted 
for mean values of all numeric covariates and mode values for all 
factor covariates.}

\item{legend}{Logical scalar for whether to include a legend. 
If TRUE, a legend will be included on the plot detailing
the covariate values used to generate the plot.}

\item{vertLines}{Logical scalar specifying whether to plot vertical 
lines at \code{w.lo} and \code{w.hi} from 0 to the  
distance function.}

\item{plotBars}{Logical scalar for whether to plot the histogram 
of distances behind the distance function.  If FALSE, no histogram 
is plotted, only the distance function line(s).}

\item{circles}{Logical scalar requesting the location of detection distances
be plotted. If TRUE, open circles are plotted at predicted distance 
function heights associated with all detection distances. For computational
simplicity, all distances are plotted for EVERY covariate class even though
observed distances belong to only one covariate class. If FALSE, circles 
are not plotted.}

\item{density}{If \code{plotBars=TRUE}, a vector giving the density of 
shading lines, in lines per inch, for the bars underneath 
the distance function, repeated as necessary to exceed the number 
of bars. Values of NULL or a number strictly less than 0 
mean solid fill using colors from parameter \code{col}. 
If \code{density = 0}, bars are not filled and only the borders are rendered. 
If \code{density} > 0, bars are shaded with colors and angles from 
parameters \code{col} and \code{angle}.}

\item{angle}{When \code{density} > 0, the slope of bar shading lines, 
given as an angle in degrees (counter-clockwise), repeated as necessary
to exceed the number of bars.}

\item{xlab}{Label for the x-axis}

\item{ylab}{Label for the y-axis}

\item{border}{The color of bar borders when bars are plotted, 
repeated as necessary to exceed the number of bars. A 
value of NA or FALSE means no borders. If bars are shaded with lines 
(i.e., \code{density>0}), \code{border = TRUE} uses the same 
color for the border as for the shading lines.  Otherwise, fill color
or shaded line color are specified in \code{col} while 
border color is specified in \code{border}.}

\item{col}{A vector of bar fill colors or line colors when bars are 
drawn and \code{density != 0}, repeated as necessary to exceed the number
of bars. Also used for the bar borders when
\code{border = TRUE}.}

\item{col.dfunc}{Color of the distance function(s).
If only one distance function (one line) is being plotted, 
the default color is "red".
If covariates or \code{newdata} are present, 
the default value uses \code{graphics::rainbow(n)}, 
where \code{n} is the number 
of plotted distance functions.  Otherwise, \code{col.dfunc} 
is replicated to the required length.  Plot all 
distance functions in the same color by setting 
\code{col.dfunc} to
a scalar. Plot blue-red pairs of distance functions 
by setting \code{col.dfunc} = \code{c("blue", "red")}. Etc.}

\item{lty.dfunc}{Line type of the distance function(s).
If covariates or \code{newdata} is present, 
the default uses line types  
to \code{1:n}, where \code{n} is the number 
of plotted distance functions.  Otherwise, \code{lty.dfunc} 
is replicated to the required length. Plot solid lines
by specifying \code{lty.dfunc = 1}. Plot solid-dashed line pairs
by specifying \code{lty.dfunc = c(1,2)}. Etc.}

\item{lwd.dfunc}{Line width of the distance function(s), replicated 
to the required length. Default is 2 for all lines.}

\item{\dots}{When bars are plotted, this routine 
uses \code{graphics::barplot} to draw the 
plotting region and bars. When bars are not plotted,
this routine sets up the plot with \code{graphics::plot}.
\dots can be any argument to \code{barplot} or \code{plot} EXCEPT  
\code{width}, \code{ylim}, \code{xlim}, 
\code{density}, \code{angle}, and \code{space}. For example, 
set the main title with \code{main = "Main Title"}.}
}
\value{
The input distance function is returned, with two additional
  components than can be used to reconstruct the plotted bars.  (To 
  obtain values of the plotted distance functions, use \code{predict}
  with \code{type = "distances"}.) 
  The additional components are:
  \item{barHeights}{A vector containing the scaled bar heights drawn 
  on the plot.}
  \item{barWidths}{A vector or scalar of the bar widths drawn on 
  the plot, with measurement units.  }
  Re-plot the bars with \code{barplot( return$barHeights, 
  width = return$barWidths )}.
}
\description{
Plot method for parametric line and point transect distance functions.
}
\examples{

# Simulated data
set.seed(87654)
x <- rnorm(1000, mean=0, sd=20)
x <- x[x >= 0]
x <- setUnits(x, "ft")
Df <- data.frame(transectID = "A"
               , distance = x
                ) |> 
  dplyr::nest_by( transectID
               , .key = "detections") |> 
  dplyr::mutate(length = setUnits(1,"mi"))
attr(Df, "detectionColumn") <- "detections"
attr(Df, "obsType") <- "single"
attr(Df, "transType") <- "line"
attr(Df, "effortColumn") <- "length"
is.RdistDf(Df) # TRUE

# Estimation
dfunc <- dfuncEstim(Df
                  , formula = distance~1
                  , likelihood="halfnorm")
plot(dfunc)
plot(dfunc, nbins=25)

}
\seealso{
\code{\link{plot.dfunc}}
}
