% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpsonCoefs.R
\name{simpsonCoefs}
\alias{simpsonCoefs}
\title{Simpson numerical integration coefficients}
\usage{
simpsonCoefs(n)
}
\arguments{
\item{n}{Number of coefficients, which is the number of points 
at which the function of interest is evaluated.  The number of 
intervals is \code{(n-1)/2}.  This number must be odd.}
}
\value{
A vector of Simpson Composite rule coefficients 
suitable for numeric integration. The return is a vector of 
integers alternating between 4 and 2, with 1's on each end.
}
\description{
Return a vector of Simpson's Composite numerical integration 
coefficients.
}
\details{
Let \code{x} be an vector of equally spaced points in the domain 
of a function f (equally spaced is critical). 
Let \code{y = f(x)}. The numeric integral of f from \code{min(x)} 
to \code{max(x)} is 
\code{sum(simpsonCoefs(length(y)) * y) * (x[2] - x[1]) / 3}.
}
\examples{

x <- seq(0, 9, length=13)
y <- x^2

scoefs <- simpsonCoefs(length(x))

# exact integral is 9^3/3 = 243
sum( scoefs*y ) * (x[2] - x[1]) / 3

}
