% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitHelper_%#%.R, R/unitHelper_%acre%.R,
%   R/unitHelper_%cm%.R, R/unitHelper_%ft%.R, R/unitHelper_%ha%.R,
%   R/unitHelper_%inches%.R, R/unitHelper_%km%.R, R/unitHelper_%km^2%.R,
%   R/unitHelper_%m%.R, R/unitHelper_%m^2%.R, R/unitHelper_%mi%.R,
%   R/unitHelper_%mi^2%.R, R/unitHelper_%yd%.R, R/unitHelper_dropUnits.R,
%   R/unitHelper_setUnits.R
\name{\%#\%}
\alias{\%#\%}
\alias{unitHelpers}
\alias{\%acre\%}
\alias{\%cm\%}
\alias{\%ft\%}
\alias{\%ha\%}
\alias{\%inches\%}
\alias{\%km\%}
\alias{\%km^2\%}
\alias{\%m\%}
\alias{\%m^2\%}
\alias{\%mi\%}
\alias{\%mi^2\%}
\alias{\%yd\%}
\alias{dropUnits}
\alias{setUnits}
\title{Unit assignment helpers}
\usage{
x \%#\% u

x \%acre\% .

x \%cm\% .

x \%ft\% .

x \%ha\% .

x \%inches\% .

x \%km\% .

x \%km^2\% .

x \%m\% .

x \%m^2\% .

x \%mi\% .

x \%mi^2\% .

x \%yd\% .

dropUnits(x)

setUnits(x, u)
}
\arguments{
\item{x}{A numeric vector or matrix.}

\item{u}{A string representing physical measurement units to 
assign to \code{x}, e.g., "m", "km", "m^2".  Valid units are  
listed in columns "(symbol|name)" of \code{\link[units]{valid_udunits}}.}

\item{.}{Placeholder for the fixed unit assignment operators. Ignored.
See Details.}
}
\value{
For \%#\% and \code{setUnits}, argument \code{x} with 
units \code{u} attached.

For all the fixed unit assignment operators (i.e., \%<units>\%), 
argument x with the respective units assigned.

For \code{dropUnits}, argument \code{x} with no units. If 
input \code{x} has no units, \code{x} is returned unchanged.
}
\description{
Helper functions for assigning physical measurement units in Rdistance. 
All are convenience wrappers for \code{units::}\code{\link[units]{set_units}}.
}
\details{
The fixed unit assignment operators are designed to behave somewhat like 
unary operators (i.e., 1 argument);
but, R does not allow 
user defined unary operators. 
Technically, the fixed unit assignment operators are instances of
R's user-defined infix 
operator, and as such they require two arguments. 
Their syntax must be 
\code{x \%<units>\% <something>}; but, the second argument is ignored
and '.' is suggested. See Examples.
}
\examples{

2 \%#\% "m" 
setUnits(2,"km")
x <- 2 \%#\% "km^2"
10 \%#\% units(x)
2 \%#\% "km^2" \%#\% "acres" # Convert km^2 to acres
x \%#\% "acres"            # Same
x \%#\% NULL    # Drop units
dropUnits(x)  # Same

# \%#\%'s precedence is below "^" but above "+" and "*"
# The following fails: 
# 2 \%#\% "m" / (2 \%#\% "ha") \%#\% "in/acre"
# The following succeeds:
(2 \%#\% "m" / (2 \%#\% "ha")) \%#\% "in/acre"
1 \%m\%. ^ 2      # [m]
(1 \%m\%.) ^ 2    # [m^2]


# For fixed unit assignment, 2nd argument does not matter
# All of the following are equivalent
2 \%m\%.
2 \%m\% x
2 \%m\% 3
2 \%m\% NULL
2 \%m\% NA

# Conversion:
x <- 10 \%#\% "ft"
x \%m\%.

}
