% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{duckdb_type_mappings}
\alias{duckdb_type_mappings}
\title{DuckDB to R Type Mappings}
\usage{
duckdb_type_mappings()
}
\value{
A named list with two elements:
\describe{
  \item{duckdb_to_r}{Named character vector mapping DuckDB types to R types}
  \item{r_to_duckdb}{Named character vector mapping R types to DuckDB types}
}
}
\description{
The mapping covers the most common data types used in HTS file processing:
\itemize{
  \item BIGINT <-> double (not integer due to 64-bit overflow protection)
  \item DOUBLE <-> numeric/double
  \item VARCHAR <-> character/string
  \item BOOLEAN <-> logical
  \item ARRAY types (e.g., VARCHAR[], BIGINT[]) <-> list
  \item MAP types (e.g., MAP(VARCHAR, VARCHAR)) <-> data.frame
}

Important notes:
\itemize{
  \item 64-bit integers (BIGINT, UBIGINT) become double to prevent overflow
  \item DATE/TIME values return as Unix epoch numbers (double)
  \item MAP types become data frames with 'key' and 'value' columns
  \item ARRAY types become vectors (which are lists in R terminology)
}
}
\details{
Returns a named list mapping between DuckDB and R data types.
This is useful for understanding type conversions when reading
HTS files or when specifying column types in tabix functions.
}
\examples{
mappings <- duckdb_type_mappings()
mappings$duckdb_to_r["BIGINT"]
mappings$r_to_duckdb["integer"]

}
