% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{normalize_tabix_types}
\alias{normalize_tabix_types}
\title{Normalize R Data Types to DuckDB Types for Tabix}
\usage{
normalize_tabix_types(types)
}
\arguments{
\item{types}{A character vector of R data type names to be normalized.}
}
\value{
A character vector of normalized DuckDB type names suitable for tabix columns.
}
\description{
Normalizes R data type names to their corresponding DuckDB types for use with
tabix readers. This function handles common R type name variations and maps them
to appropriate DuckDB column types.
}
\details{
The function performs the following normalizations:
\itemize{
\item Integer types (integer, int, int32, int64) -> BIGINT
\item Numeric types (numeric, double, float) -> DOUBLE
\item Character types (character, string, chr) -> VARCHAR
\item Logical types (logical, bool, boolean) -> BOOLEAN
\item Other types -> Converted to uppercase as-is
}
If an empty vector is provided, it returns the empty vector unchanged.
}
\examples{
normalize_tabix_types(c("integer", "character", "numeric"))
normalize_tabix_types(c("int", "string", "float"))

}
\seealso{
\code{\link{rduckhts_tabix}} for using normalized types with tabix readers,
\code{\link{duckdb_type_mappings}} for the complete type mapping table.
}
