% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{geometric_hazard}
\alias{geometric_hazard}
\title{Geometric Hazard Prior}
\usage{
geometric_hazard(lambda = 0.01)
}
\arguments{
\item{lambda}{Hazard rate (probability of changepoint at each step).
Should be between 0 and 1. Smaller values expect fewer changepoints.}
}
\value{
An object of class "hazard_prior"
}
\description{
Creates a geometric (constant hazard) prior for the changepoint process.
This implies that the probability of a changepoint at each time step is
constant and independent.
}
\details{
Under a geometric hazard, the expected run length (time between changepoints)
is 1/lambda. For example, lambda = 0.01 expects a changepoint every 100 observations
on average.
}
\examples{
hazard <- geometric_hazard(lambda = 0.01)

hazard <- geometric_hazard(lambda = 0.1)

}
