% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dQXGP.R
\name{dQXGP}
\alias{dQXGP}
\alias{pQXGP}
\alias{qQXGP}
\alias{rQXGP}
\alias{hQXGP}
\title{The Quasi XGamma Poisson distribution}
\usage{
dQXGP(x, mu, sigma, nu, log = FALSE)

pQXGP(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qQXGP(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rQXGP(n, mu, sigma, nu)

hQXGP(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dQXGP} gives the density, \code{pQXGP} gives the distribution 
function, \code{qQXGP} gives the quantile function, \code{rQXGP}
generates random deviates and \code{hQXGP} gives the hazard function.
}
\description{
Density, distribution function,quantile function, 
random generation and hazard function for the Quasi XGamma Poisson distribution 
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Quasi XGamma Poisson distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by:

\eqn{f(x)= K(\mu, \sigma, \nu)(\frac {\sigma^{2} x^{2}}{2} + \mu)
 exp(\frac{\nu exp(-\sigma x)(1 + \mu + \sigma x + \frac {\sigma^{2}x^{2}}{2})}{1+\mu} - \sigma x),}

for \eqn{x > 0}, \eqn{\mu> 0}, \eqn{\sigma> 0}, \eqn{\nu> 1}.

where

\eqn{K(\mu, \sigma, \nu) = \frac{\nu \sigma}{(exp(\nu)-1)(1+\mu)}}
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function
curve(dQXGP(x, mu=0.5, sigma=1, nu=1), from=0.1, to=8,
      ylim=c(0, 0.6), col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow=c(1, 2))
curve(pQXGP(x, mu=0.5, sigma=1, nu=1),
      from=0.1, to=8,  col="red", las=1, ylab="F(x)")
curve(pQXGP(x,  mu=0.5, sigma=1, nu=1, lower.tail=FALSE),
      from=0.1, to=8, col="red", las=1, ylab="R(x)")

## The quantile function
p <- seq(from=0, to=0.99999, length.out=100)
plot(x=qQXGP(p, mu=0.5, sigma=1, nu=1), y=p, xlab="Quantile",
     las=1, ylab="Probability")
curve(pQXGP(x, mu=0.5, sigma=1, nu=1),
      from=0.1, add=TRUE, col="red")
      
## The random function
hist(rQXGP(n=1000, mu=0.5, sigma=1, nu=1), freq=FALSE,
     xlab="x", ylim=c(0, 0.4), las=1, main="", xlim=c(0, 15))
curve(dQXGP(x, mu=0.5, sigma=1, nu=1),
      from=0.001, to=500, add=TRUE, col="red")

## The Hazard function
curve(hQXGP(x, mu=0.5, sigma=1, nu=1), from=0.01, to=3,
      col="red", ylab="Hazard function", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
Sen, S., Korkmaz, M. Ç., & Yousof, H. M. (2018). 
The quasi XGamma-Poisson distribution: properties and
application. Istatistik Journal of The Turkish Statistical 
Association, 11(3), 65-76.
}
\seealso{
\link{QXGP}
}
\author{
Simon Zapata
}
