% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWGEE.R
\name{dWGEE}
\alias{dWGEE}
\alias{pWGEE}
\alias{qWGEE}
\alias{rWGEE}
\alias{hWGEE}
\title{The Weighted Generalized Exponential-Exponential distribution}
\usage{
dWGEE(x, mu, sigma, nu, log = FALSE)

pWGEE(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qWGEE(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rWGEE(n, mu, sigma, nu)

hWGEE(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{nu}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dWGEE} gives the density, \code{pWGEE} gives the distribution 
function, \code{qWGEE} gives the quantile function, \code{rWGEE}
generates random deviates and \code{hWGEE} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the Weighted Generalized Exponential-Exponential distribution 
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The Weighted Generalized Exponential-Exponential Distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x)= \sigma \nu \exp(-\nu x) (1 - \exp(-\nu x))^{\sigma - 1} (1 - \exp(-\mu \nu x)) / 1 - \sigma B(\mu + 1, \sigma),}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{\nu > 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function 
curve(dWGEE(x, mu = 5, sigma = 0.5, nu = 1), from = 0, to = 6, 
ylim = c(0, 1), col = "red", las = 1, ylab = "The probability density function")

## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(pWGEE(x, mu = 5, sigma = 0.5, nu = 1), from = 0, to = 6, 
ylim = c(0, 1), col = "red", las = 1, ylab = "The cumulative distribution function")
curve(pWGEE(x, mu = 5, sigma = 0.5, nu = 1, lower.tail = FALSE), 
from = 0, to = 6, ylim = c(0, 1), col = "red", las = 1, ylab = "The Reliability function")

## The quantile function
p <- seq(from = 0, to = 0.99999, length.out = 100)
plot(x = qWGEE(p = p, mu = 5, sigma = 0.5, nu = 1), y = p, 
xlab = "Quantile", las = 1, ylab = "Probability")
curve(pWGEE(x, mu = 5, sigma = 0.5, nu = 1), from = 0, add = TRUE, 
col = "red")

## The random function
hist(rWGEE(1000, mu = 5, sigma = 0.5, nu = 1), freq = FALSE, xlab = "x", 
ylim = c(0, 1), las = 1, main = "")
curve(dWGEE(x, mu = 5, sigma = 0.5, nu = 1),  from = 0, add = TRUE, 
col = "red", ylim = c(0, 1))

## The Hazard function(
par(mfrow=c(1,1))
curve(hWGEE(x, mu = 5, sigma = 0.5, nu = 1), from = 0, to = 6, 
ylim = c(0, 1.4), col = "red", ylab = "The hazard function", las = 1)

par(old_par) # restore previous graphical parameters
}
\references{
Mahdavi, A. (2015). Two weighted distributions generated by 
exponential distribution. Journal of Mathematical Extension, 9, 1-12.
}
\seealso{
\link{WGEE}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
