% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_score.R
\name{survival_score_functions}
\alias{survival_score_functions}
\alias{h_lr_score_no_strata_no_cov}
\alias{h_lr_score_strat}
\alias{h_lr_score_cov}
\alias{h_lr_score_strat_cov}
\title{Log-Rank Score Functions for Survival Analysis}
\usage{
h_lr_score_no_strata_no_cov(
  theta,
  df,
  treatment,
  time,
  status,
  randomization_strata = character(),
  n = nrow(df),
  use_ties_factor = TRUE,
  calculate_variance = TRUE,
  check_rand_strat_warning = FALSE
)

h_lr_score_strat(
  theta,
  df,
  treatment,
  time,
  status,
  strata,
  randomization_strata = character(),
  use_ties_factor = TRUE,
  calculate_variance = TRUE,
  check_rand_strat_warning = FALSE
)

h_lr_score_cov(
  theta,
  df,
  treatment,
  time,
  status,
  model,
  randomization_strata = character(),
  theta_hat = theta,
  use_ties_factor = TRUE,
  hr_se_plugin_adjusted = TRUE,
  calculate_variance = TRUE,
  check_rand_strat_warning = FALSE
)

h_lr_score_strat_cov(
  theta,
  df,
  treatment,
  time,
  status,
  strata,
  model,
  randomization_strata = character(),
  theta_hat = theta,
  use_ties_factor = TRUE,
  hr_se_plugin_adjusted = TRUE,
  calculate_variance = TRUE,
  check_rand_strat_warning = FALSE
)
}
\arguments{
\item{theta}{(\code{number}) The assumed log hazard ratio of the second vs. the first level of the
treatment arm variable.}

\item{df}{(\code{data.frame}) The data frame containing the survival data.}

\item{treatment}{(\code{string}) The name of the treatment arm variable in \code{df}. It should be a factor with
two levels, where the first level is the reference group.}

\item{time}{(\code{string}) The name of the time variable in \code{df}, representing the survival time.}

\item{status}{(\code{string}) The name of the status variable in \code{df}, with 0 for censored and 1 for event.}

\item{randomization_strata}{(\code{character}) The names of the randomization strata variables in \code{df}.
These are used to check whether the means of the covariate adjustment residuals are unbiased across
these strata.}

\item{n}{(\code{count}) The number of observations. Note that this can be higher than the number of rows
when used in stratified analyses computations.}

\item{use_ties_factor}{(\code{flag}) Whether to use the ties factor in the variance calculation. This is used
when calculating the score test statistic, but not when estimating the log hazard ratio.}

\item{calculate_variance}{(\code{flag}) Whether to calculate the variance. This is useful to avoid
unnecessary computations when only the score function value is needed, e.g., during root finding.}

\item{strata}{(\code{character}) The names of the strata variables in \code{df}, which must be factors.}

\item{model}{(\code{formula}) The model formula for covariate adjustment, e.g., \code{~ cov1 + cov2}.}

\item{theta_hat}{(\code{number}) The estimated log hazard ratio when not adjusting for covariates.}

\item{hr_se_plugin_adjusted}{(\code{flag}) Defines the method for calculating the standard error of the
log hazard ratio estimate when adjusting for covariates, see details.}
}
\value{
The score function value(s), with the following attributes:
\itemize{
\item \code{sigma_l2}: The variance of the log-rank statistic.
\item \code{se_theta_l}: The corresponding standard error term for the log hazard ratio.
\item \code{n}: The number of observations used in the calculation.
}
}
\description{
These functions compute the log-rank score statistics for a survival analysis.
Depending on the function, these are stratified and/or adjusted for covariates.
}
\details{
\itemize{
\item The \code{hr_se_plugin_adjusted} flag is relevant only for the standard error of the covariate adjusted
log hazard ratio estimate: When \code{TRUE}, the adjusted hazard ratio estimate
is plugged in into the variance formula, as per the original publication.
On the other hand, when \code{FALSE}, the unadjusted estimate is used instead.  This is explained in more
detail in the vignette "Survival Analysis with RobinCar2" in Section "Covariate adjusted analysis without strata".
\item Note that for the not covariate adjusted score functions, these also work
with a \code{numeric} \code{theta} vector of length > 1.
}
}
\section{Functions}{
\itemize{
\item \code{h_lr_score_no_strata_no_cov()}: without strata or covariates.

\item \code{h_lr_score_strat()}: with strata but without covariates.

\item \code{h_lr_score_cov()}: with covariates but without strata.

\item \code{h_lr_score_strat_cov()}: with strata and covariates.

}}
\keyword{internal}
