% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{visualize_results}
\alias{visualize_results}
\title{Visualize MCMC results}
\usage{
visualize_results(
  samples,
  true_values = NULL,
  title = "Results",
  burnin_frac = 0.2,
  true_covariance = NULL,
  show_acf = TRUE
)
}
\arguments{
\item{samples}{Matrix of MCMC samples.}

\item{true_values}{Optional vector of true parameter values.}

\item{title}{Plot title.}

\item{burnin_frac}{Burn-in fraction.}

\item{true_covariance}{Optional true covariance matrix.}

\item{show_acf}{Logical; whether to display autocorrelation plots.}
}
\description{
Produces trace plots, marginal densities and joint plots
depending on the dimension of the parameter space.
}
\examples{
log_post <- function(x) dnorm(x, log = TRUE)
res <- twalk(log_post, n_iter = 2000, x0 = -2, xp0 = 2)
visualize_results(
  res$all_samples,
  true_values = 0,
  title = "Standard normal"
)

}
