% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_env_bins.R
\name{get_env_bins}
\alias{get_env_bins}
\title{Identify Environmental Blocks and Group Nearby Records in Environmental Space}
\usage{
get_env_bins(
  occ,
  species = "species",
  long = "decimalLongitude",
  lat = "decimalLatitude",
  env_layers,
  n_bins = 5
)
}
\arguments{
\item{occ}{(data.frame or data.table) a data frame containing the occurrence
records for a \strong{single species}. Must contain columns for species, longitude, and latitude.}

\item{species}{(character) the name of the column in \code{occ} that contains the
species scientific names. Default is \code{"species"}.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{env_layers}{(SpatRaster) object containing environmental variables.}

\item{n_bins}{(numeric) number of bins into which each environmental variable
will be divided.}
}
\value{
A list with:
\itemize{
\item \strong{data}: a data frame including extracted environmental values, bin
indices, and a unique \code{block_id} for each record.
\item \strong{breaks}: a named list of numeric vectors containing the break points
for each variable (used by \code{plot_env_bins()}).
}
}
\description{
This function creates a multidimensional grid in environmental space by
splitting each environmental variable into \code{n_bins} equally sized intervals.
It then assigns each occurrence record to an environmental block (bin
combination) and identifies records that fall into the same block (i.e.,
records that are close to each other in environmental space).

The results can be visualized using the \code{plot_env_bins()} function.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Get only occurrences from Araucaria
occ <- occurrences[occurrences$species == "Araucaria angustifolia", ]
# Load example of raster variables
data("worldclim", package = "RuHere")
# Unwrap Packed raster
r <- terra::unwrap(worldclim)
# Get bins
b <- get_env_bins(occ = occ, env_layers = r, n_bins = 5)

}
