% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dglm_likelihood.R
\name{dglm_likelihood}
\alias{dglm_likelihood}
\title{Calculate Log-Likelihood for DGLM}
\usage{
dglm_likelihood(
  y,
  X,
  beta,
  family = c("poisson", "pareto", "gamma"),
  alpha_gamma = 2,
  lambda_min = 1e-06
)
}
\arguments{
\item{y}{Numeric response vector (length n).}

\item{X}{Numeric design matrix (n x p).}

\item{beta}{Numeric coefficient vector (length p).}

\item{family}{Character distribution choice: "poisson", "pareto", or "gamma".}

\item{alpha_gamma}{Shape parameter for Gamma (default 2).}

\item{lambda_min}{Lower bound for Pareto shape lambda (default 1e-6).}
}
\value{
Numeric vector of length n; -Inf for illegal observations.
}
\description{
Element-wise log-likelihood for Dynamic Generalized Linear Models
with linear predictor eta = X * beta.
}
\examples{
set.seed(123)
X <- matrix(rnorm(100 * 3), 100, 3)
beta <- c(0.5, -0.2, 0.1)

# Poisson
y_pois <- rpois(100, lambda = exp(X \%*\% beta))
ll_pois <- dglm_likelihood(y_pois, X, beta, family = "poisson")

# Gamma
y_gamma <- rgamma(100, shape = 3, rate = exp(X \%*\% beta))
ll_gamma <- dglm_likelihood(y_gamma, X, beta, family = "gamma", alpha_gamma = 3)

}
