% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview_module.R
\name{preview_module}
\alias{preview_module}
\title{Preview a module}
\usage{
preview_module(
  module_id = NULL,
  ui_imports = NULL,
  server_imports = NULL,
  ui_elements = sia_head_tag(),
  save_and_document = TRUE,
  load = TRUE,
  proj = curr_proj(),
  ...
)
}
\arguments{
\item{module_id}{\emph{character}, name of the module to preview (including the
prefix). If \code{NULL} (the default), all modules discovered by \code{\link[=get_modules]{get_modules()}}
are listed and you are asked to pick one.}

\item{ui_imports}{\emph{list}, UI objects exported from the \code{{ShinyItemAnalysis}}
app. \emph{Not used at the moment}.}

\item{server_imports}{\emph{list}, reactive objects exported from the
\code{{ShinyItemAnalysis}} app. See the Details.}

\item{ui_elements}{elements to include in \code{fluidPage}, preferably packed in
\code{tagList()}.}

\item{save_and_document}{\emph{logical}, whether to \link[rstudioapi:rstudio-documents]{save all} unsaved files (only available in RStudio)
and \link[roxygen2:roxygenize]{document} the package. Defaults to \code{TRUE}. Note
that documenting the package is necessary if you use any functions from
external packages (to produce the \code{NAMESPACE}).}

\item{load}{\emph{logical}, whether to \link[pkgload:load_all]{load} your package
before running the module preview. Defaults to \code{TRUE}. Note that you have
to load the package by yourself or install it in the usual way if you set
this to \code{FALSE}.}

\item{proj}{\emph{character}, a path to the project. Defaults to \link[=curr_proj]{current project}.}

\item{...}{
  Arguments passed on to \code{\link[shiny:shinyApp]{shiny::shinyApp}}
  \describe{
    \item{\code{onStart}}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}
    \item{\code{options}}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}
    \item{\code{uiPattern}}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}
    \item{\code{enableBookmarking}}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. The default value, \code{NULL}, will respect the setting from
any previous calls to  \code{\link[shiny:enableBookmarking]{enableBookmarking()}}. See \code{\link[shiny:enableBookmarking]{enableBookmarking()}}
for more information on bookmarking your app.}
  }}
}
\value{
Shiny app object of class \code{shiny.appobj}.
}
\description{
Previews a SIA module in a standalone development environment. See the
details below.
}
\details{
The function takes module's function bindings and puts (or evaluates) them
inside a bare bone \code{\link[shiny:shinyApp]{shiny::shinyApp()}}. By default, a customized head tag is
injected in order to mimic the "environment" of full \code{{ShinyItemAnalysis}}
app. See \code{\link[=sia_head_tag]{sia_head_tag()}} for more details. Besides, a \code{onSessionEnded} hook
is set to call \code{\link[shiny:stopApp]{shiny::stopApp()}} after the client disconnects, so the
"process" is automatically quit after you close the preview in your browser
or RStudio viewer.

In order to use the function bindings, \code{preview_module()} attempts to
\link[pkgload:load_all]{load} your package without the actual installation by
default.
\strong{Note that you have to install the package as usual for
\code{{ShinyItemAnalysis}} to detect your modules.}
\subsection{Using objects from the  \code{{ShinyItemAnalysis}} app}{

Note that this "emulated" preview environment is really meant to test the
basic UI layout and functionality and is not able to receive any object from
\code{{ShinyItemAnalysis}} app. However, you can pass any object like
\code{{ShinyItemAnalysis}} does to \code{server_imports} argument manually. For further
details and examples, please refer to \code{vignette("imports", "SIAtools")}
vignette.
}
}
\examples{
if (interactive()) {
  preview_module()
}

}
\seealso{
Other module management functions:
\code{\link{add_module}()},
\code{\link{get_modules}()},
\code{\link{remove_module}()}
}
\concept{module_management}
