% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_map_all.R
\name{s_map}
\alias{s_map}
\alias{s_map_chr}
\alias{s_map_dbl}
\alias{s_map_int}
\alias{s_map_lgl}
\alias{s_map_dfr}
\alias{s_map_dfc}
\title{Safe Map - Drop-in Replacement for purrr::map with Auto-Recovery}
\usage{
s_map(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_chr(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_dbl(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_int(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_lgl(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_dfr(.x, .f, ..., .id = NULL, .session_id = NULL)

s_map_dfc(.x, .f, ..., .id = NULL, .session_id = NULL)
}
\arguments{
\item{.x}{A list or atomic vector to map over.}

\item{.f}{A function, formula, or vector.}

\item{...}{Additional arguments passed to .f.}

\item{.id}{Either a string or NULL (used for dfr/dfc variants).}

\item{.session_id}{Character. Optional session ID for this operation.
If NULL (default), a session ID is automatically generated from the
input data, enabling seamless recovery without user intervention.}
}
\value{
A list, same as purrr::map.

A character vector.

A double vector.

An integer vector.

A logical vector.

A data frame (row bind).

A data frame (column bind).
}
\description{
Apply a function to each element of a list or vector with automatic
checkpointing and recovery. If interrupted, simply run the same code
again to resume from where it left off.
}
\examples{
# Basic usage - identical to purrr::map
result <- s_map(1:10, ~ .x^2)

}
