% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/seurat.R
\name{GetImage}
\alias{GetImage}
\alias{GetImage.Seurat}
\title{Get image data}
\usage{
GetImage(object, mode = c("grob", "raster", "plotly", "raw"), ...)

\method{GetImage}{Seurat}(
  object,
  mode = c("grob", "raster", "plotly", "raw"),
  image = NULL,
  ...
)
}
\arguments{
\item{object}{An object}

\item{mode}{How to return the image; should accept one of \dQuote{grob},
\dQuote{raster}, \dQuote{plotly}, or \dQuote{raw}}

\item{...}{Arguments passed to other methods}

\item{image}{Name of \code{SpatialImage} object to pull image data for; if
\code{NULL}, will attempt to select an image automatically}
}
\value{
Image data, varying depending on the value of \code{mode}:
\describe{
 \item{\dQuote{grob}}{
  An object representing image data inheriting from \code{grob} objects
  (eg. \code{rastergrob})
 }
 \item{\dQuote{raster}}{An object of class \code{raster}}
 \item{\dQuote{plotly}}{
  A list with image data suitable for Plotly rendering, see
  \code{\link[plotly:layout]{plotly::layout}} for more details
 }
 \item{\dQuote{raw}}{The raw image data as stored in the object}
}
}
\description{
Get image data
}
\seealso{
\code{\link[plotly]{layout}}
}
\concept{data-access}
