% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probability_parameter.R
\name{extract_dataset_features}
\alias{extract_dataset_features}
\title{Extract Dataset Characteristics for Adaptive Parameter Calculation (Use in package)}
\usage{
extract_dataset_features(
  seurat_obj,
  features,
  assay = NULL,
  cluster_col = NULL
)
}
\arguments{
\item{seurat_obj}{Seurat object}

\item{features}{Features to analyze}

\item{assay}{Assay name}

\item{cluster_col}{Cluster column name}
}
\value{
List of dataset characteristics including expression statistics,
variability measures, and cluster properties
}
\description{
Computes various statistical features from single-cell data that are used
as input for the parameter prediction model.
}
\seealso{
Other Section_1_Functions_Use_in_Package: 
\code{\link{calculate_cluster_variability}()},
\code{\link{calculate_expression}()},
\code{\link{calculate_expression_skewness}()},
\code{\link{calculate_probability}()},
\code{\link{compute_adaptive_parameters}()},
\code{\link{estimate_batch_effect}()}
}
\concept{Section_1_Functions_Use_in_Package}
