% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_forest_matrix.R
\name{survival_forest_matrix}
\alias{survival_forest_matrix}
\title{Build a Survival Forest (Data Supplied as Matrices)}
\usage{
survival_forest_matrix(
  time,
  event,
  matrix_numeric,
  matrix_factor,
  weights = rep(1, length(time)),
  significance = 0.05,
  min_weights = 50,
  missing = "omit",
  test_type = "univariate",
  cut_type = 0,
  nboot = 100,
  seed = 0,
  args_miceRanger = NULL
)
}
\arguments{
\item{time}{survival times, a numeric vector. 
\code{time[i]} is the survival time of the ith sample.}

\item{event}{survival events, a logical vector. 
\code{event[i]} is the survival event of the ith sample.}

\item{matrix_numeric}{numeric predictors, a numeric matrix. 
\code{matrix_numeric[i,j]} is the jth numeric predictor of the ith sample.}

\item{matrix_factor}{factor predictors, a character matrix. 
\code{matrix_factor[i,j]} is the jth predictor of the ith sample.}

\item{weights}{sample weights, a numeric vector. 
\code{weights[i]} is the weight of the ith sample.}

\item{significance}{significance threshold, a numeric value. 
Stop the splitting algorithm when no splits give a p-value smaller than \code{significance}.}

\item{min_weights}{minimum weight threshold, a numeric value. 
The weights in a node are greater than \code{min_weights}.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.}

\item{test_type}{a character value that specifies the type of statistical tests.
If \code{test_type=="univariate"}, then it performs a log-rank test without p-value adjustments.
If \code{test_type} is in \code{p.adjust.methods}, i.e., one of holm, hochberg, hommel, bonferroni, BH, BY, or fdr, 
then the p-values will be adjusted using the corresponding method.}

\item{cut_type}{an integer value that specifies how to cut between two numeric values.
If \code{cut_type==0}, then cut at the ends.
If \code{cut_type==1}, then cut from the middle.
If \code{cut_type==2}, then cut randomly between the two values.}

\item{nboot}{an integer value that specifies the number of bootstrap replications.}

\item{seed}{an integer value that specifies the seed.}

\item{args_miceRanger}{a list specifying additional arguments to be used to impute missing data using \code{miceRanger()}. 
Only applies when \code{missing=="miceRanger"}.}
}
\value{
A list containing the information of the survival forest fit.
}
\description{
The function 
\code{survival_forest_matrix} build a survival forest given the survival outcomes and predictors of numeric and factor variables.
}
\details{
Build a Survival Forest (Data Supplied as Matrices)
}
\examples{
\donttest{
library(survival)
a_survival_forest<-
  survival_forest_matrix(
    time=lung$time,
    event=lung$status==2,
    matrix_numeric=data.matrix(lung[,c(4,6:9),drop=FALSE]),
    matrix_factor=data.matrix(lung[,5,drop=FALSE]),
    nboot=20)
}
}
