% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile-math.R
\name{osm_native}
\alias{osm_native}
\alias{osm_lnglat}
\alias{osm_crs_native}
\alias{osm_ensure_lnglat}
\alias{osm_ensure_native}
\title{Coordinate helpers}
\usage{
osm_native(x, y)

osm_lnglat(lng, lat)

osm_crs_native()

osm_ensure_lnglat(pt)

osm_ensure_native(pt)
}
\arguments{
\item{x, y}{Ordinate values in EPSG:3857 (Spherical Mercator in meters)}

\item{lng, lat}{Coordinate values for longitude/latitude in degrees.}

\item{pt}{A vector of points as coerced by [wk::as_xy()]. The CRS for these
points is considered.}
}
\value{
- `osm_native()`, `osm_lnglat()`, `osm_ensure_native()`, and
    `osm_ensure_lnglat()` return a [wk::xy()] with the appropriate
    crs
  - `osm_crs_native()` returns a value that can be used as the [wk::wk_crs()]
    of a vector.
}
\description{
Coordinate helpers
}
\examples{
osm_lnglat(-64, 45)
osm_ensure_native(osm_lnglat(-64, 45))
osm_ensure_lnglat(
  osm_ensure_native(osm_lnglat(-64, 45))
)
}
