% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_stability.R
\name{classification_stability}
\alias{classification_stability}
\title{Stability Index for Classification Models}
\usage{
classification_stability(class_matrix)
}
\arguments{
\item{class_matrix}{A matrix or data.frame where each row represents
an observation and each column represents a predicted class (factor
or character) from a single model run.}
}
\value{
A numeric scalar between 0 and 1, where 1 indicates perfect
consistency and 0 indicates consistency no better than chance.
}
\description{
Computes the stability of classification predictions across multiple
runs. For classification, stability is measured as the average
agreement between pairs of runs, adjusted for chance (similar to
Cohen's Kappa but extended for multiple runs).
}
\examples{
# Simulate classification predictions from 3 runs
preds <- data.frame(
    run1 = c("A", "A", "B", "C"),
    run2 = c("A", "B", "B", "C"),
    run3 = c("A", "A", "B", "C")
)
classification_stability(preds)

}
