% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_search.R
\name{TextAnalyzer}
\alias{TextAnalyzer}
\title{Text Analyzer}
\description{
Text analyzer for search indexing

Provides text processing pipelines:
\itemize{
\item Tokenization
\item Lowercasing
\item Stopword removal
\item Stemming
\item Synonym expansion
}
}
\examples{
\dontrun{
analyzer <- TextAnalyzer$english()
tokens <- analyzer$analyze("The quick brown foxes are jumping")
# c("quick", "brown", "fox", "jump")
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lowercase}}{Convert to lowercase}

\item{\code{remove_stopwords}}{Remove stopwords}

\item{\code{stopwords}}{Set of stopwords}

\item{\code{stemmer}}{Stemmer object}

\item{\code{synonyms}}{Synonym dictionary}

\item{\code{min_token_length}}{Minimum token length}

\item{\code{max_token_length}}{Maximum token length}

\item{\code{token_pattern}}{Regex pattern for tokens}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TextAnalyzer-new}{\code{TextAnalyzer$new()}}
\item \href{#method-TextAnalyzer-analyze}{\code{TextAnalyzer$analyze()}}
\item \href{#method-TextAnalyzer-analyze_query}{\code{TextAnalyzer$analyze_query()}}
\item \href{#method-TextAnalyzer-clone}{\code{TextAnalyzer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextAnalyzer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TextAnalyzer-new}{}}}
\subsection{Method \code{new()}}{
Create a new TextAnalyzer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextAnalyzer$new(
  lowercase = TRUE,
  remove_stopwords = FALSE,
  stopwords = NULL,
  use_stemmer = FALSE,
  synonyms = NULL,
  min_token_length = 1,
  max_token_length = 100,
  token_pattern = "[a-zA-Z0-9]+"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lowercase}}{Lowercase text (default: TRUE)}

\item{\code{remove_stopwords}}{Remove stopwords (default: FALSE)}

\item{\code{stopwords}}{Custom stopwords (default: ENGLISH_STOPWORDS)}

\item{\code{use_stemmer}}{Use stemming (default: FALSE)}

\item{\code{synonyms}}{Named list of synonyms}

\item{\code{min_token_length}}{Min length (default: 1)}

\item{\code{max_token_length}}{Max length (default: 100)}

\item{\code{token_pattern}}{Regex pattern}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextAnalyzer-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-TextAnalyzer-analyze}{}}}
\subsection{Method \code{analyze()}}{
Analyze text and return tokens
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextAnalyzer$analyze(text)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{Input text}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of tokens
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextAnalyzer-analyze_query"></a>}}
\if{latex}{\out{\hypertarget{method-TextAnalyzer-analyze_query}{}}}
\subsection{Method \code{analyze_query()}}{
Analyze a query string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextAnalyzer$analyze_query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query text}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Character vector of tokens
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TextAnalyzer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TextAnalyzer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TextAnalyzer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
