% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2array.R
\name{df2array}
\alias{df2array}
\title{Long-format data frame to array}
\usage{
df2array(
  df,
  margins = 1:(ncol(df) - 1),
  values = ncol(df),
  NA2zeros = TRUE,
  names = TRUE,
  ...
)
}
\arguments{
\item{df}{A long-format data frame.}

\item{margins}{A vector of integers indicating which columns of \code{df} should be mapped to the
dimensions of the array, and in what order. By default, \code{1:(ncol(df)-1)},
meaning all columns of \code{df} except the last are mapped to dimensions in the
order they appear in the data frame.}

\item{values}{An integer specifying which column of \code{df} is mapped to the cell values
of the array. By default, \code{ncol(df)}, meaning that the values of the last column of \code{df}
are used as the cell values.}

\item{NA2zeros}{A \code{TRUE}/\code{FALSE} argument indicating whether intersections of levels
not present in \code{df} should be imputed with zero. Default, \code{TRUE}.}

\item{names}{A \code{TRUE}/\code{FALSE} argument indicating whether the level labels of the factors
should be used as dimension names (\code{dimnames}) for the array. Default is \code{TRUE}.}

\item{...}{Other arguments to be passed to the function. Not currently used.}
}
\value{
An array with \code{length(margins)} dimensions.
}
\description{
Organizes the information in a long-format data frame with N factor
columns and one value column into a K-dimensional array (K \eqn{\le} N),
where the size of each dimension corresponds to the number of levels
of the respective factor.
}
\examples{
 x <- structure(list(LF1 = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                             1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L,
                             2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                             2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L,
                             3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
                             3L, 3L, 3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L,
                             4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
                             4L, 4L, 4L, 4L, 4L),
                     LF2 = c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
                             3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 1L, 1L,
                             1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L,
                             3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 1L, 1L, 1L, 1L,
                             1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L,
                             3L, 4L, 4L, 4L, 4L, 4L, 4L, 1L, 1L, 1L, 1L, 1L, 1L,
                             2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 4L,
                             4L, 4L, 4L, 4L, 4L),
                     LF3 = c(1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L,
                             2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L,
                             3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L,
                             4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L,
                             5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L,
                             6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L,
                             1L, 2L, 3L, 4L, 5L, 6L, 1L, 2L, 3L, 4L, 5L, 6L, 1L,
                             2L, 3L, 4L, 5L, 6L),
                    ix = c(0.8812, 0.8887, 1.0035, 0.8782, 1.1580, 1.3894, 0.7986,
                           1.0170, 1.0875, 0.9499, 0.9524, 1.1707, 0.4907, 1.4251,
                           0.8045, 0.7830, 0.7144, 0.9673, 0.5705, 6.8399, 0.6700,
                           0.6110, 2.1088, 0.7673, 0.8206, 1.0989, 1.0824, 0.7626,
                           1.1863, 1.6287, 0.8107, 0.8689, 1.0907, 0.9404, 0.9957,
                           1.2035, 0.5604, 0.9439, 0.8367, 0.7845, 0.8614, 1.0996,
                           0.3270, 1.1892, 0.6776, 0.5313, 0.7801, 0.9651, 1.2576,
                           1.1939, 1.2554, 1.1225, 1.5741, 1.5718, 0.8092, 0.8460,
                           1.0899, 1.0742, 1.0668, 1.0680, 0.8204, 0.8988, 1.0015,
                           1.0354, 0.9541, 1.0639, 0.5223, 0.6963, 0.6749, 0.7230,
                           0.6616, 0.9579, 1.1752, 1.3359, 1.2824, 1.6836, 1.5313,
                           2.5715, 1.0579, 0.8304, 1.0632, 1.0016, 0.9370, 1.1711,
                           0.7874, 1.4360, 1.0949, 0.8646, 0.8430, 1.4736, 0.7795,
                           0.9362, 0.8489, 0.8246, 0.8449, 0.6331)),
                           row.names = c(NA, -96L), class = "data.frame")

example <- df2array(df = x, margins = c(2, 1, 3))

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
