% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.adj}
\alias{plot.adj}
\title{Basic plotting for adjacency lists}
\usage{
\method{plot}{adj}(x, y = NULL, edges = NULL, nodes = TRUE, xlab = NA, ylab = NA, ...)
}
\arguments{
\item{x}{An \code{adj} list}

\item{y}{Optional matrix of coordinates for each node. If \code{NULL}, nodes are
plotted along the diagonal. Other types are accepted as long as they are
convertible to a 2-column matrix with \code{as.matrix(y)[, 1:2]}, which is run
internally.}

\item{edges}{Type of line to use when drawing edges. Passed to \code{\link[graphics:lines]{graphics::lines()}}.
When \code{y} is \code{NULL}, defaults to \code{"s"} (step function); otherwise defaults
to \code{"l"} for a straight line.}

\item{nodes}{If \code{TRUE}, nodes are plotted as points; if \code{FALSE}, only edges are plotted.}

\item{xlab, ylab}{Labels for the x- and y-axes.}

\item{...}{Additional arguments passed on to the initial \code{plot()} of the nodes.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Plots an adjacency list as a set of nodes and edges, with optional coordinate
values for each node. Edge thickness is proportional to the number of edges
between each pair of nodes. Self loops are represented with larger points.
}
\examples{
plot(adj(2, c(1, 3), 2))
plot(adj(2, c(1, 2, 3), c(2, 2, 2), self_loops="allow", duplicates="allow"))

a <- adj(konigsberg$bridge_to, ids = konigsberg$area, duplicates = "allow")
plot(a, konigsberg[c("x", "y")])
}
