% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{normality_test_aov}
\alias{normality_test_aov}
\title{normality_test_aov}
\usage{
normality_test_aov(df, variable_name, group_1, group_2 = NULL)
}
\arguments{
\item{df}{A data frame.}

\item{variable_name}{Name of the response variable column (string).}

\item{group_1}{Name of the first grouping column (string).}

\item{group_2}{Name of the second grouping column (string), or \code{NULL}
for a one-way model.}
}
\value{
A tibble with Shapiro-Wilk p-values for each transformation.
}
\description{
Test normality of ANOVA model residuals using Shapiro-Wilk on
  raw, square-root, and log10 transforms (one-way or two-way).
}
\examples{
df <- data.frame(
  grp = c("A","A","B","B"),
  val = c(1.1, 1.4, 3.2, 3.8)
)
normality_test_aov(df, "val", "grp")
}
