% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{normality_test_t}
\alias{normality_test_t}
\title{normality_test_t}
\usage{
normality_test_t(df, variable_name, group, group_1, group_2)
}
\arguments{
\item{df}{A data frame.}

\item{variable_name}{Name of the numeric variable column (string).}

\item{group}{<[`data-masking`][dplyr::dplyr_data_masking]> The grouping column.}

\item{group_1}{Value identifying the first group.}

\item{group_2}{Value identifying the second group.}
}
\value{
A tibble with Shapiro-Wilk p-values for each group × transformation
  combination.
}
\description{
Test normality of a variable within two groups using Shapiro-Wilk
  on raw, square-root, and log10 transforms (for t-test context).
}
\examples{
df <- data.frame(
  grp = c("A","A","A","B","B","B"),
  val = c(1.1, 2.0, 1.5, 4.2, 3.8, 4.5)
)
normality_test_t(df, "val", grp, "A", "B")
}
