% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{TimeSeries-class}
\alias{TimeSeries-class}
\alias{.TimeSeries}
\title{TimeSeries}
\description{
An S4 class to represent time series.
}
\details{
A time series object is an \eqn{n \times m \times p} array, with
\eqn{n} being the number of observations, \eqn{m} being the number of series
and with the \eqn{p} columns of the third dimension containing extra
variables for each series.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{A \eqn{n \times m \times p} \code{numeric} \code{\link{array}}
giving the observed time-series values.}

\item{\code{.Time}}{A length-\eqn{n} \code{\linkS4class{RataDie}} object.}
}}

\note{
This class inherits from \code{\link{array}}.
}
\seealso{
Other classes: 
\code{\link{GregorianCalendar-class}},
\code{\link{JulianCalendar-class}},
\code{\link{RataDie-class}},
\code{\link{TimeIntervals-class}},
\code{\link{TimeScale-class}}

Other time classes: 
\code{\link{RataDie-class}},
\code{\link{TimeIntervals-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\concept{time classes}
