% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_dist.R
\name{beta_dist}
\alias{beta_dist}
\title{Construct a beta distribution object.}
\usage{
beta_dist(shape1, shape2)
}
\arguments{
\item{shape1}{First shape parameter, must be a positive scalar.}

\item{shape2}{Second shape parameter, must be a positive scalar.}
}
\value{
A \code{beta_dist} object with classes
\code{c("beta_dist", "univariate_dist", "continuous_dist", "dist")}.
}
\description{
Creates an S3 object representing a beta distribution with shape
parameters \code{shape1} and \code{shape2}.  The PDF on \eqn{(0, 1)} is
\deqn{f(x) = \frac{x^{a-1}(1-x)^{b-1}}{B(a,b)}}
where \eqn{a} = \code{shape1}, \eqn{b} = \code{shape2}, and \eqn{B(a,b)}
is the beta function.
}
\examples{
x <- beta_dist(shape1 = 2, shape2 = 5)
mean(x)
vcov(x)
format(x)
}
